/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.RealizationCheck;
import org.apache.kylin.query.routing.RoutingRule;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter {
    private static final Logger logger = LoggerFactory.getLogger(QueryRouter.class);

    public static IRealization selectRealization(OLAPContext olapContext, Set<IRealization> realizations) throws NoRealizationFoundException {
        String factTableName = olapContext.firstTableScan.getTableName();
        String projectName = olapContext.olapSchema.getProjectName();
        SQLDigest sqlDigest = olapContext.getSQLDigest();
        ArrayList candidates = Lists.newArrayListWithCapacity((int)realizations.size());
        for (IRealization real : realizations) {
            if (real.isReady()) {
                candidates.add(new Candidate(real, sqlDigest));
            }
            if (BackdoorToggles.getForceHitCube() == null || !BackdoorToggles.getForceHitCube().equalsIgnoreCase(real.getName())) continue;
            logger.info("Force choose {} as selected cube for specific purpose.", (Object)real.getName());
            return real;
        }
        logger.info("Find candidates by table " + factTableName + " and project=" + projectName + " : " + StringUtils.join(candidates, ","));
        ArrayList originCandidates = Lists.newArrayList((Iterable)candidates);
        RoutingRule.applyRules(candidates);
        QueryRouter.collectIncapableReason(olapContext, originCandidates);
        if (candidates.size() == 0) {
            return null;
        }
        Candidate chosen = (Candidate)candidates.get(0);
        QueryRouter.adjustForDimensionAsMeasure(chosen, olapContext);
        logger.info("The realizations remaining: " + RoutingRule.getPrintableText(candidates) + ",and the final chosen one for current olap context " + olapContext.id + " is " + chosen.realization.getCanonicalName());
        for (CapabilityResult.CapabilityInfluence influence : chosen.getCapability().influences) {
            if (influence.getInvolvedMeasure() == null) continue;
            olapContext.involvedMeasure.add(influence.getInvolvedMeasure());
        }
        return chosen.realization;
    }

    private static void adjustForDimensionAsMeasure(Candidate chosen, OLAPContext olapContext) {
        CapabilityResult capability = chosen.getCapability();
        for (CapabilityResult.CapabilityInfluence inf : capability.influences) {
            if (!(inf instanceof CapabilityResult.DimensionAsMeasure)) continue;
            FunctionDesc functionDesc = ((CapabilityResult.DimensionAsMeasure)inf).getMeasureFunction();
            functionDesc.setDimensionAsMetric(true);
            logger.info("Adjust DimensionAsMeasure for " + functionDesc);
        }
    }

    private static void collectIncapableReason(OLAPContext olapContext, List<Candidate> candidates) {
        for (Candidate candidate : candidates) {
            if (!candidate.getCapability().capable) {
                RealizationCheck.IncapableReason reason = RealizationCheck.IncapableReason.create(candidate.getCapability().incapableCause);
                if (reason == null) continue;
                olapContext.realizationCheck.addIncapableCube(candidate.getRealization(), reason);
                continue;
            }
            olapContext.realizationCheck.addCapableCube(candidate.getRealization());
        }
    }
}

