/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableJoin;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPProjectRel;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPJoinRel
extends EnumerableJoin
implements OLAPRel {
    static final String[] COLUMN_ARRAY_MARKER = new String[0];
    protected OLAPContext context;
    protected ColumnRowType columnRowType;
    protected int columnRowTypeLeftRightCut;
    protected boolean isTopJoin;
    protected boolean hasSubQuery;
    protected static Constructor<EnumerableJoin> constr;

    public OLAPJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys, variablesSet, joinType);
        Preconditions.checkArgument((this.getConvention() == OLAPRel.CONVENTION ? 1 : 0) != 0);
        this.rowType = this.getRowType();
        this.isTopJoin = false;
    }

    public EnumerableJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)this.condition);
        assert (joinInfo.isEqui());
        try {
            return new OLAPJoinRel(this.getCluster(), traitSet, left, right, this.condition, joinInfo.leftKeys, joinInfo.rightKeys, (Set<CorrelationId>)this.variablesSet, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) * 0.1;
    }

    protected boolean isParentMerelyPermutation(OLAPRel.OLAPImplementor implementor) {
        if (implementor.getParentNode() instanceof OLAPProjectRel) {
            return ((OLAPProjectRel)implementor.getParentNode()).isMerelyPermutation();
        }
        return false;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        if (!(implementor.getParentNode() instanceof OLAPJoinRel) && !this.isParentMerelyPermutation(implementor)) {
            implementor.allocateContext();
        }
        this.context = implementor.getContext();
        this.context.allOlapJoins.add(this);
        this.isTopJoin = !this.context.hasJoin;
        this.context.hasJoin = true;
        boolean leftHasSubquery = false;
        boolean rightHasSubquery = false;
        implementor.fixSharedOlapTableScanOnTheLeft((BiRel)this);
        implementor.visitChild(this.left, this);
        if (this.context != implementor.getContext() || ((OLAPRel)this.left).hasSubQuery()) {
            this.hasSubQuery = true;
            leftHasSubquery = true;
            if (this.context != implementor.getContext()) {
                implementor.freeContext();
            }
        }
        if (leftHasSubquery) {
            implementor.setNewOLAPContextRequired(true);
        }
        implementor.fixSharedOlapTableScanOnTheRight((BiRel)this);
        implementor.visitChild(this.right, this);
        if (this.context != implementor.getContext() || ((OLAPRel)this.right).hasSubQuery()) {
            this.hasSubQuery = true;
            rightHasSubquery = true;
            if (leftHasSubquery) {
                Preconditions.checkState((!implementor.isNewOLAPContextRequired() ? 1 : 0) != 0);
                Preconditions.checkState((this.context != implementor.getContext() ? 1 : 0) != 0, (Object)"missing a new olapcontext");
            }
            if (this.context != implementor.getContext()) {
                implementor.freeContext();
            }
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.isTopJoin) {
            this.context.afterJoin = true;
        }
        if (!this.hasSubQuery) {
            Preconditions.checkState((boolean)(this.getCondition() instanceof RexCall), (Object)"Cartesian Join is not supported.");
            RexCall condition = (RexCall)this.getCondition();
            JoinDesc join2 = this.buildJoin(condition);
            JoinRelType joinRelType = this.getJoinType();
            String joinType = joinRelType == JoinRelType.INNER ? "INNER" : (joinRelType == JoinRelType.LEFT ? "LEFT" : (joinRelType == JoinRelType.RIGHT ? "RIGHT" : "FULL"));
            join2.setType(joinType);
            this.context.joins.add(join2);
        } else {
            HashMultimap joinCol = HashMultimap.create();
            this.translateJoinColumn(this.getCondition(), (Multimap<TblColRef, TblColRef>)joinCol);
            for (Map.Entry columnPair : joinCol.entries()) {
                TblColRef fromCol = rightHasSubquery ? (TblColRef)columnPair.getKey() : (TblColRef)columnPair.getValue();
                this.context.subqueryJoinParticipants.add(fromCol);
            }
            joinCol.clear();
        }
    }

    protected ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        OLAPRel olapLeft = (OLAPRel)this.left;
        ColumnRowType leftColumnRowType = olapLeft.getColumnRowType();
        columns.addAll(leftColumnRowType.getAllColumns());
        this.columnRowTypeLeftRightCut = columns.size();
        OLAPRel olapRight = (OLAPRel)this.right;
        ColumnRowType rightColumnRowType = olapRight.getColumnRowType();
        columns.addAll(rightColumnRowType.getAllColumns());
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    protected JoinDesc buildJoin(RexCall condition) {
        HashMultimap joinColumns = HashMultimap.create();
        this.translateJoinColumn(condition, (Multimap<TblColRef, TblColRef>)joinColumns);
        ArrayList<String> pks = new ArrayList<String>();
        ArrayList<TblColRef> pkCols = new ArrayList<TblColRef>();
        ArrayList<String> fks = new ArrayList<String>();
        ArrayList<TblColRef> fkCols = new ArrayList<TblColRef>();
        for (Map.Entry columnPair : joinColumns.entries()) {
            TblColRef fromCol = (TblColRef)columnPair.getKey();
            TblColRef toCol = (TblColRef)columnPair.getValue();
            fks.add(fromCol.getName());
            fkCols.add(fromCol);
            pks.add(toCol.getName());
            pkCols.add(toCol);
        }
        JoinDesc join2 = new JoinDesc();
        join2.setForeignKey(fks.toArray(COLUMN_ARRAY_MARKER));
        join2.setForeignKeyColumns(fkCols.toArray(new TblColRef[fkCols.size()]));
        join2.setPrimaryKey(pks.toArray(COLUMN_ARRAY_MARKER));
        join2.setPrimaryKeyColumns(pkCols.toArray(new TblColRef[pkCols.size()]));
        join2.sortByFK();
        return join2;
    }

    protected void translateJoinColumn(RexNode condition, Multimap<TblColRef, TblColRef> joinCol) {
        if (condition instanceof RexCall) {
            this.translateJoinColumn((RexCall)condition, joinCol);
        }
    }

    void translateJoinColumn(RexCall condition, Multimap<TblColRef, TblColRef> joinColumns) {
        SqlKind kind = condition.getOperator().getKind();
        if (kind == SqlKind.AND) {
            for (RexNode operand : condition.getOperands()) {
                RexCall subCond = (RexCall)operand;
                this.translateJoinColumn(subCond, joinColumns);
            }
        } else if (kind == SqlKind.EQUALS) {
            List operands = condition.getOperands();
            RexInputRef op0 = (RexInputRef)operands.get(0);
            TblColRef col0 = this.columnRowType.getColumnByIndex(op0.getIndex());
            RexInputRef op1 = (RexInputRef)operands.get(1);
            TblColRef col1 = this.columnRowType.getColumnByIndex(op1.getIndex());
            if (op0.getIndex() < this.columnRowTypeLeftRightCut) {
                joinColumns.put((Object)col0, (Object)col1);
            } else {
                joinColumns.put((Object)col1, (Object)col0);
            }
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.hasSubQuery) {
            try {
                return (EnumerableRel)constr.newInstance(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputs.get(0), inputs.get(1), this.condition, this.leftKeys, this.rightKeys, this.variablesSet, this.joinType);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't create EnumerableJoin!", e);
            }
        }
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray());
        RelOptTable factTable = this.context.firstTableScan.getTable();
        MethodCallExpression exprCall = Expressions.call((Expression)factTable.getExpression(OLAPTable.class), (String)"executeOLAPQuery", (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.id)});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.left);
        implementor.visitChild(this, this.right);
        this.rowType = this.deriveRowType();
        if (this.isTopJoin) {
            Map<TblColRef, RelDataType> dynFields;
            if (OLAPRel.RewriteImplementor.needRewrite(this.context) && this.context.hasPrecalculatedFields()) {
                int paramIndex = this.rowType.getFieldList().size();
                LinkedList<RelDataTypeFieldImpl> newFieldList = new LinkedList<RelDataTypeFieldImpl>();
                for (Map.Entry<String, RelDataType> rewriteField : this.context.rewriteFields.entrySet()) {
                    String fieldName = rewriteField.getKey();
                    if (this.rowType.getField(fieldName, true, false) != null) continue;
                    RelDataType fieldType = rewriteField.getValue();
                    RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, paramIndex++, fieldType);
                    newFieldList.add(newField);
                }
                RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
                fieldInfo.addAll((Iterable)this.rowType.getFieldList());
                fieldInfo.addAll(newFieldList);
                this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
                this.columnRowType = this.buildColumnRowType();
            }
            if (!(dynFields = this.context.dynamicFields).isEmpty()) {
                ArrayList newCols = Lists.newArrayList(this.columnRowType.getAllColumns());
                ArrayList newFieldList = Lists.newArrayList();
                int paramIndex = this.rowType.getFieldList().size();
                for (TblColRef fieldCol : dynFields.keySet()) {
                    RelDataType fieldType = dynFields.get(fieldCol);
                    RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldCol.getName(), paramIndex++, fieldType);
                    newFieldList.add(newField);
                    newCols.add(fieldCol);
                }
                RelDataTypeFactory.FieldInfoBuilder fieldInfo = this.getCluster().getTypeFactory().builder();
                fieldInfo.addAll((Iterable)this.rowType.getFieldList());
                fieldInfo.addAll((Iterable)newFieldList);
                this.rowType = this.getCluster().getTypeFactory().createStructType((RelDataTypeFactory.FieldInfo)fieldInfo);
                this.columnRowType = new ColumnRowType(newCols);
            }
        }
    }

    public boolean isRuntimeJoin() {
        if (this.context != null) {
            this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        }
        return this.context == null || ((OLAPRel)this.left).getContext() != ((OLAPRel)this.right).getContext();
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public boolean hasSubQuery() {
        return this.hasSubQuery;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)(this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization));
    }

    static {
        try {
            constr = EnumerableJoin.class.getDeclaredConstructor(RelOptCluster.class, RelTraitSet.class, RelNode.class, RelNode.class, RexNode.class, ImmutableIntList.class, ImmutableIntList.class, Set.class, JoinRelType.class);
            constr.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

