/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.sdk.datasource.framework.JdbcConnector;
import org.apache.kylin.sdk.datasource.framework.SourceConnectorFactory;
import org.apache.kylin.source.adhocquery.AbstractPushdownRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushdownRunnerSDKImpl
extends AbstractPushdownRunner {
    public static final Logger logger = LoggerFactory.getLogger(PushdownRunnerSDKImpl.class);
    private JdbcConnector dataSource;

    @Override
    public void init(KylinConfig config) {
        this.dataSource = SourceConnectorFactory.getJdbcConnector(config);
    }

    @Override
    public void executeQuery(String sql2, List<List<String>> results, List<SelectedColumnMeta> columnMetas) {
        ResultSet rs = null;
        try (Connection conn = this.dataSource.getConnection();
             Statement state = conn.createStatement();){
            rs = state.executeQuery(sql2);
            this.extractResults(rs, results);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                int kylinTypeId = this.dataSource.toKylinTypeId(metaData.getColumnTypeName(i), metaData.getColumnType(i));
                String kylinTypeName = this.dataSource.toKylinTypeName(kylinTypeId);
                columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), false, metaData.isCurrency(i), metaData.isNullable(i), false, metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), null, null, null, metaData.getPrecision(i), metaData.getScale(i), kylinTypeId, kylinTypeName, metaData.isReadOnly(i), false, false));
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("executeQuery failed", e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        DBUtils.closeQuietly(rs);
    }

    @Override
    public void executeUpdate(String sql2) {
        try {
            this.dataSource.executeUpdate(sql2);
        }
        catch (Exception e) {
            throw new RuntimeException("executeUpdate failed", e);
        }
    }

    @Override
    public String convertSql(KylinConfig kylinConfig, String sql2, String project, String defaultSchema, boolean isPrepare) {
        String converted = sql2;
        String ret = this.dataSource.convertSql(converted);
        if (!converted.equals(ret)) {
            logger.debug("the query is converted to {} after applying SDK converter.", (Object)ret);
        }
        return ret;
    }

    private void extractResults(ResultSet resultSet, List<List<String>> results) throws SQLException {
        LinkedList<String> oneRow = new LinkedList<String>();
        while (resultSet.next()) {
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(new LinkedList(oneRow));
            oneRow.clear();
        }
    }
}

