/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.realization.RoutingIndicatorException;
import org.apache.kylin.query.relnode.OLAPFilterRel;
import org.apache.kylin.query.relnode.OLAPJoinRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPJoinRule
extends ConverterRule {
    public static final ConverterRule INSTANCE = new OLAPJoinRule();

    public OLAPJoinRule() {
        super(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)OLAPRel.CONVENTION, "OLAPJoinRule");
    }

    public RelNode convert(RelNode rel) {
        OLAPRel newRel;
        LogicalJoin join2 = (LogicalJoin)rel;
        RelNode left = join2.getInput(0);
        RelNode right = join2.getInput(1);
        RelTraitSet traitSet = join2.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION);
        left = OLAPJoinRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION));
        right = OLAPJoinRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION));
        JoinInfo info = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)join2.getCondition());
        RelOptCluster cluster = join2.getCluster();
        try {
            if (!info.isEqui() && join2.getJoinType() != JoinRelType.INNER) {
                throw new RoutingIndicatorException("Currently, Non-equi SQL is not supported by Kylin");
            }
            newRel = new OLAPJoinRel(cluster, traitSet, left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join2.getVariablesSet(), join2.getJoinType());
            if (!info.isEqui()) {
                newRel = new OLAPFilterRel(cluster, newRel.getTraitSet(), newRel, info.getRemaining(join2.getCluster().getRexBuilder()));
            }
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
        if (!info.isEqui()) {
            newRel = new OLAPFilterRel(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
        }
        return newRel;
    }
}

