/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import java.util.Locale;
import org.apache.kylin.shaded.com.google.common.base.Strings;

public enum TimePropertyEnum {
    YEAR("KYEAR_BEGIN_DATE"),
    MONTH("KMONTH_BEGIN_DATE"),
    WEEK_BEGIN_DATE("KWEEK_BEGIN_DATE"),
    DAY_DATE("KDAY_DATE"),
    DAY_TIME("KDAY_TIME"),
    TIME_HOUR("KTIME_HOUR"),
    TIME_MINUTE("KTIME_MINUTE"),
    TIME_SECOND("KTIME_SECOND");

    private final String propertyName;

    private TimePropertyEnum(String propertyName) {
        this.propertyName = propertyName;
    }

    public static TimePropertyEnum getByPropertyName(String propertyName) {
        if (Strings.isNullOrEmpty(propertyName)) {
            return null;
        }
        for (TimePropertyEnum property : TimePropertyEnum.values()) {
            if (!property.propertyName.equals(propertyName.toUpperCase(Locale.ROOT))) continue;
            return property;
        }
        return null;
    }

    public String toString() {
        return this.propertyName;
    }
}

