/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordEvent
implements Record,
Map<String, Object>,
Serializable {
    private static final Logger logger;
    private static final ThreadLocal<ByteArrayOutputStream> _localBaos;
    public static final String LOCAL_HOSTNAME;
    private final Map<String, Object> backingMap;

    private RecordEvent(Map<String, Object> map) {
        this.backingMap = map;
    }

    public RecordEvent(String eventType) {
        this(eventType, LOCAL_HOSTNAME);
    }

    public RecordEvent(String eventType, String host) {
        this(eventType, host, System.currentTimeMillis());
    }

    public RecordEvent(String eventType, String host, long time2) {
        this(null, eventType, host, time2);
    }

    public RecordEvent(Map<String, Object> map, String eventType, String host, long time2) {
        this.backingMap = map != null ? map : Maps.newHashMap();
        this.setEventType(eventType);
        this.setHost(host);
        this.setTime(time2);
    }

    public String getEventType() {
        return (String)this.get(RecordReserveKeyEnum.EVENT_SUBJECT.toString());
    }

    private void setEventType(String eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("EventType cannot be null.");
        }
        this.put(RecordReserveKeyEnum.EVENT_SUBJECT.toString(), (Object)eventType);
    }

    public String getHost() {
        return (String)this.get(RecordReserveKeyEnum.HOST.toString());
    }

    private void setHost(String host) {
        this.put(RecordReserveKeyEnum.HOST.toString(), (Object)host);
    }

    @Override
    public Long getTime() {
        return (Long)this.get(RecordReserveKeyEnum.TIME.toString());
    }

    private void setTime(Long time2) {
        if (time2 == null) {
            throw new IllegalArgumentException("Time cannot be null.");
        }
        this.put(RecordReserveKeyEnum.TIME.toString(), (Object)time2);
    }

    public void resetTime() {
        this.setTime(System.currentTimeMillis());
    }

    public String getID() {
        return (String)this.get(RecordReserveKeyEnum.ID.toString());
    }

    public void setID(String id) {
        this.put(RecordReserveKeyEnum.ID.toString(), (Object)id);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) || this.backingMap.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.backingMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.backingMap.putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.backingMap.remove(key);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    public String toString() {
        return this.backingMap.toString();
    }

    @Override
    public Collection<Object> values() {
        return this.backingMap.values();
    }

    @Override
    public String getSubject() {
        return this.getEventType();
    }

    @Override
    public byte[] getKey() {
        return (this.getHost() + "-" + this.getTime() + "-" + this.getID()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Map<String, Object> getValueRaw() {
        HashMap<String, Object> cloneMap = Maps.newHashMap(this.backingMap);
        cloneMap.remove(RecordReserveKeyEnum.EVENT_SUBJECT.toString());
        return cloneMap;
    }

    @Override
    public byte[] getValue() {
        try {
            ByteArrayOutputStream baos = _localBaos.get();
            if (baos == null) {
                baos = new ByteArrayOutputStream();
                _localBaos.set(baos);
            }
            baos.reset();
            JsonUtil.writeValue(baos, this.getValueRaw());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RecordEvent clone() {
        HashMap<String, Object> cloneMap = Maps.newHashMap();
        cloneMap.putAll(this.backingMap);
        return new RecordEvent(cloneMap);
    }

    static {
        String localHostname1;
        logger = LoggerFactory.getLogger(RecordEvent.class);
        _localBaos = new ThreadLocal();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localHostname1 = addr.getHostName() + ":" + addr.getHostAddress();
            logger.info("RecordEvent using hostname : {}.", (Object)localHostname1);
        }
        catch (UnknownHostException e) {
            logger.info("Unexpected ", e);
            localHostname1 = "Unknown";
        }
        LOCAL_HOSTNAME = localHostname1;
    }

    public static enum RecordReserveKeyEnum {
        EVENT_SUBJECT("EVENT_TYPE"),
        ID("EVENT_ID"),
        HOST("HOST"),
        TIME("KTIMESTAMP");

        private final String reserveKey;

        private RecordReserveKeyEnum(String key) {
            this.reserveKey = key;
        }

        public String toString() {
            return this.reserveKey;
        }

        public RecordReserveKeyEnum getByKey(String key) {
            for (RecordReserveKeyEnum reserveKey : RecordReserveKeyEnum.values()) {
                if (!reserveKey.reserveKey.equalsIgnoreCase(key)) continue;
                return reserveKey;
            }
            return null;
        }
    }
}

