/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metrics.QuerySparkMetrics;
import org.apache.kylin.metrics.lib.ActiveReservoir;
import org.apache.kylin.metrics.lib.ActiveReservoirRecordFilter;
import org.apache.kylin.metrics.lib.impl.StubReservoir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSystem
extends MetricRegistry {
    public static final MetricsSystem Metrics = new MetricsSystem();
    private static final Logger logger = LoggerFactory.getLogger(MetricsSystem.class);
    private final ConcurrentHashMap<String, ActiveReservoir> activeReservoirs = new ConcurrentHashMap();

    private MetricsSystem() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("Closing Metrics System");
                try {
                    MetricsSystem.this.shutdown();
                }
                catch (IOException e) {
                    logger.error("error during shutdown activeReservoirs and listeners", e);
                }
                logger.info("Closed Metrics System");
            }
        });
    }

    public void shutdown() throws IOException {
        QuerySparkMetrics.getInstance().getQueryExecutionMetricsMap().invalidateAll();
        for (ActiveReservoir entry : this.activeReservoirs.values()) {
            entry.close();
        }
    }

    public ActiveReservoir activeReservoir(String name) {
        return this.getOrAddActiveReservoir(name);
    }

    public ActiveReservoir register(String name, ActiveReservoir activeReservoir) {
        if (name == null || activeReservoir == null) {
            throw new IllegalArgumentException("neither of name or ActiveReservoir can be null");
        }
        ActiveReservoir existingReservoir = this.activeReservoirs.putIfAbsent(name, activeReservoir);
        if (existingReservoir != null) {
            throw new IllegalArgumentException("An active reservoir named " + name + " already exists");
        }
        this.onActiveReservoirAdded(activeReservoir);
        return activeReservoir;
    }

    public boolean removeActiveReservoir(String name) {
        ActiveReservoir recordReservoir = this.activeReservoirs.remove(name);
        if (recordReservoir != null) {
            this.onActiveReservoirRemoved(recordReservoir);
            return true;
        }
        return false;
    }

    public void removeActiveReservoirMatching(ActiveReservoirRecordFilter filter2) {
        for (Map.Entry<String, ActiveReservoir> entry : this.activeReservoirs.entrySet()) {
            if (!filter2.matches(entry.getKey(), entry.getValue())) continue;
            this.removeActiveReservoir(entry.getKey());
        }
    }

    private void onActiveReservoirAdded(ActiveReservoir activeReservoir) {
        activeReservoir.start();
    }

    private void onActiveReservoirRemoved(ActiveReservoir activeReservoir) {
        try {
            activeReservoir.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SortedMap<String, ActiveReservoir> getActiveReservoirs() {
        return this.getActiveReservoirs(ActiveReservoirRecordFilter.ALL);
    }

    public SortedMap<String, ActiveReservoir> getActiveReservoirs(ActiveReservoirRecordFilter filter2) {
        TreeMap<String, ActiveReservoir> reservoirs = new TreeMap<String, ActiveReservoir>();
        for (Map.Entry<String, ActiveReservoir> entry : this.activeReservoirs.entrySet()) {
            if (!filter2.matches(entry.getKey(), entry.getValue())) continue;
            reservoirs.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableSortedMap(reservoirs);
    }

    private ActiveReservoir getOrAddActiveReservoir(String name) {
        ActiveReservoir activeReservoir = this.activeReservoirs.get(name);
        if (activeReservoir != null) {
            return activeReservoir;
        }
        String defaultActiveReservoirClass = KylinConfig.getInstanceFromEnv().getKylinMetricsActiveReservoirDefaultClass();
        try {
            activeReservoir = (ActiveReservoir)Class.forName(defaultActiveReservoirClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.warn("Failed to initialize the " + defaultActiveReservoirClass + ". The StubReservoir will be used");
            activeReservoir = new StubReservoir();
        }
        return this.register(name, activeReservoir);
    }
}

