/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;

public class SQLDigest {
    public String factTable;
    public Set<TblColRef> allColumns;
    public List<JoinDesc> joinDescs;
    public List<TblColRef> groupbyColumns;
    public Set<TblColRef> subqueryJoinParticipants;
    public Map<TblColRef, TupleExpression> dynGroupbyColumns;
    public boolean groupByExpression;
    public Set<TblColRef> metricColumns;
    public List<FunctionDesc> aggregations;
    public List<SQLCall> aggrSqlCalls;
    public List<DynamicFunctionDesc> dynAggregations;
    public Set<TblColRef> rtDimensionColumns;
    public Set<TblColRef> rtMetricColumns;
    public Set<TblColRef> filterColumns;
    public TupleFilter filter;
    public TupleFilter havingFilter;
    public List<TblColRef> sortColumns;
    public List<OrderEnum> sortOrders;
    public boolean isRawQuery;
    public boolean isBorrowedContext;
    public boolean limitPrecedesAggr;
    public boolean hasLimit;
    public Set<MeasureDesc> involvedMeasure;

    public SQLDigest(String factTable, Set<TblColRef> allColumns, List<JoinDesc> joinDescs, List<TblColRef> groupbyColumns, Set<TblColRef> subqueryJoinParticipants, Map<TblColRef, TupleExpression> dynGroupByColumns, boolean groupByExpression, Set<TblColRef> metricColumns, List<FunctionDesc> aggregations, List<SQLCall> aggrSqlCalls, List<DynamicFunctionDesc> dynAggregations, Set<TblColRef> rtDimensionColumns, Set<TblColRef> rtMetricColumns, Set<TblColRef> filterColumns, TupleFilter filter2, TupleFilter havingFilter, List<TblColRef> sortColumns, List<OrderEnum> sortOrders, boolean limitPrecedesAggr, boolean hasLimit, boolean isBorrowedContext, Set<MeasureDesc> involvedMeasure) {
        this.factTable = factTable;
        this.allColumns = allColumns;
        this.joinDescs = joinDescs;
        this.groupbyColumns = groupbyColumns;
        this.subqueryJoinParticipants = subqueryJoinParticipants;
        this.dynGroupbyColumns = dynGroupByColumns;
        this.groupByExpression = groupByExpression;
        this.metricColumns = metricColumns;
        this.aggregations = aggregations;
        this.aggrSqlCalls = aggrSqlCalls;
        this.dynAggregations = dynAggregations;
        this.rtDimensionColumns = rtDimensionColumns;
        this.rtMetricColumns = rtMetricColumns;
        this.filterColumns = filterColumns;
        this.filter = filter2;
        this.havingFilter = havingFilter;
        this.sortColumns = sortColumns;
        this.sortOrders = sortOrders;
        this.isRawQuery = this.isRawQuery();
        this.isBorrowedContext = isBorrowedContext;
        this.limitPrecedesAggr = limitPrecedesAggr;
        this.hasLimit = hasLimit;
        this.involvedMeasure = involvedMeasure;
        this.includeSubqueryJoinParticipants();
    }

    private boolean isRawQuery() {
        return this.groupbyColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public void includeSubqueryJoinParticipants() {
        if (this.isRawQuery) {
            this.allColumns.addAll(this.subqueryJoinParticipants);
        } else {
            this.groupbyColumns.addAll(this.subqueryJoinParticipants);
            this.allColumns.addAll(this.subqueryJoinParticipants);
        }
    }

    public String toString() {
        return "fact table " + this.factTable + ",group by " + this.groupbyColumns + ",filter on " + this.filterColumns + ",with aggregates" + this.aggregations + ".";
    }

    public static class SQLCall {
        public final String function;
        public final List<Object> args;

        public SQLCall(String function, Iterable<Object> args) {
            this.function = function;
            this.args = ImmutableList.copyOf(args);
        }
    }

    public static enum OrderEnum {
        ASCENDING,
        DESCENDING;

    }
}

