/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.Function;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PartitionDesc
implements Serializable {
    @JsonProperty(value="partition_date_column")
    private String partitionDateColumn;
    @JsonProperty(value="partition_time_column")
    private String partitionTimeColumn;
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_format")
    private String partitionDateFormat = "yyyy-MM-dd";
    @JsonProperty(value="partition_time_format")
    private String partitionTimeFormat = "HH:mm:ss";
    @JsonProperty(value="partition_type")
    private PartitionType partitionType = PartitionType.APPEND;
    @JsonProperty(value="partition_condition_builder")
    private String partitionConditionBuilderClz = DefaultPartitionConditionBuilder.class.getName();
    private TblColRef partitionDateColumnRef;
    private TblColRef partitionTimeColumnRef;
    private IPartitionConditionBuilder partitionConditionBuilder;

    public void init(DataModelDesc model) {
        if (StringUtils.isEmpty(this.partitionDateColumn)) {
            return;
        }
        this.partitionConditionBuilder = (IPartitionConditionBuilder)ClassUtil.newInstance(this.partitionConditionBuilderClz);
        if (this.partitionConditionBuilder instanceof CustomYearMonthDayFieldPartitionConditionBuilder) {
            ((CustomYearMonthDayFieldPartitionConditionBuilder)this.partitionConditionBuilder).init(this, model);
        } else {
            this.partitionDateColumnRef = model.findColumn(this.partitionDateColumn);
            this.partitionDateColumn = this.partitionDateColumnRef.getIdentity();
            if (!StringUtils.isBlank(this.partitionTimeColumn)) {
                this.partitionTimeColumnRef = model.findColumn(this.partitionTimeColumn);
                this.partitionTimeColumn = this.partitionTimeColumnRef.getIdentity();
            }
        }
    }

    public boolean partitionColumnIsYmdInt() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return (type.isInt() || type.isBigInt()) && DateFormat.isDatePattern(this.partitionDateFormat);
    }

    public boolean partitionColumnIsTimeMillis() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isBigInt() && !DateFormat.isDatePattern(this.partitionDateFormat);
    }

    public boolean isPartitioned() {
        return this.partitionDateColumnRef != null;
    }

    public String getPartitionDateColumn() {
        return this.partitionDateColumn;
    }

    public void setPartitionDateColumn(String partitionDateColumn) {
        this.partitionDateColumn = partitionDateColumn;
    }

    void setPartitionDateColumnRef(TblColRef partitionDateColumnRef) {
        this.partitionDateColumnRef = partitionDateColumnRef;
    }

    public String getPartitionTimeColumn() {
        return this.partitionTimeColumn;
    }

    public void setPartitionTimeColumn(String partitionTimeColumn) {
        this.partitionTimeColumn = partitionTimeColumn;
    }

    void setPartitionTimeColumnRef(TblColRef partitionTimeColumnRef) {
        this.partitionTimeColumnRef = partitionTimeColumnRef;
    }

    @Deprecated
    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    @Deprecated
    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public String getPartitionDateFormat() {
        return this.partitionDateFormat;
    }

    public void setPartitionDateFormat(String partitionDateFormat) {
        this.partitionDateFormat = partitionDateFormat;
    }

    public String getPartitionTimeFormat() {
        return this.partitionTimeFormat;
    }

    public void setPartitionTimeFormat(String partitionTimeFormat) {
        this.partitionTimeFormat = partitionTimeFormat;
    }

    public PartitionType getCubePartitionType() {
        return this.partitionType;
    }

    public void setCubePartitionType(PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public String getPartitionConditionBuilderClz() {
        return this.partitionConditionBuilderClz;
    }

    public void setPartitionConditionBuilderClz(String partitionConditionBuilderClz) {
        this.partitionConditionBuilderClz = partitionConditionBuilderClz;
    }

    public IPartitionConditionBuilder getPartitionConditionBuilder() {
        return this.partitionConditionBuilder;
    }

    public TblColRef getPartitionDateColumnRef() {
        return this.partitionDateColumnRef;
    }

    public TblColRef getPartitionTimeColumnRef() {
        return this.partitionTimeColumnRef;
    }

    public static PartitionDesc getCopyOf(PartitionDesc orig) {
        PartitionDesc ret = new PartitionDesc();
        ret.partitionDateColumn = orig.partitionDateColumn;
        ret.partitionTimeColumn = orig.partitionTimeColumn;
        ret.partitionDateStart = orig.partitionDateStart;
        ret.partitionDateFormat = orig.partitionDateFormat;
        ret.partitionTimeFormat = orig.partitionTimeFormat;
        ret.partitionType = orig.partitionType;
        ret.partitionConditionBuilderClz = orig.partitionConditionBuilderClz;
        return ret;
    }

    public static class CustomYearMonthDayFieldPartitionConditionBuilder
    implements IPartitionConditionBuilder,
    Serializable {
        private String yearPartitionDateColumn;
        private String monthPartitionDateColumn;
        private String dayPartitionDateColumn;

        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange, Function<TblColRef, String> func) {
            long startInclusive = (Long)segRange.start.v;
            long endExclusive = (Long)segRange.end.v;
            TblColRef partitionColumn = partDesc.getPartitionDateColumnRef();
            if (partitionColumn != null) {
                partitionColumn.setQuotedFunc(func);
            }
            String concatField = String.format(Locale.ROOT, "CONCAT(%s,'-',%s,'-',%s)", this.yearPartitionDateColumn, this.monthPartitionDateColumn, this.dayPartitionDateColumn);
            StringBuilder builder = new StringBuilder();
            if (startInclusive > 0L) {
                builder.append(concatField + " >= '" + DateFormat.formatToDateStr(startInclusive) + "' ");
                builder.append("AND ");
            }
            builder.append(concatField + " < '" + DateFormat.formatToDateStr(endExclusive) + "'");
            return builder.toString();
        }

        public void init(PartitionDesc partitionDesc, DataModelDesc model) {
            String[] yearMonthDayColumns = partitionDesc.getPartitionDateColumn().split(",");
            if (yearMonthDayColumns.length != 3) {
                throw new IllegalArgumentException(partitionDesc.getPartitionDateColumn() + " is not year, month, and day columns");
            }
            TblColRef yearRef = model.findColumn(yearMonthDayColumns[0]);
            this.yearPartitionDateColumn = yearRef.getIdentity();
            this.monthPartitionDateColumn = model.findColumn(yearMonthDayColumns[1]).getIdentity();
            this.dayPartitionDateColumn = model.findColumn(yearMonthDayColumns[2]).getIdentity();
            partitionDesc.setPartitionDateColumnRef(yearRef);
        }
    }

    public static class YearMonthDayPartitionConditionBuilder
    implements IPartitionConditionBuilder {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange, Function<TblColRef, String> func) {
            long startInclusive = (Long)segRange.start.v;
            long endExclusive = (Long)segRange.end.v;
            TblColRef partitionColumn = partDesc.getPartitionDateColumnRef();
            Preconditions.checkNotNull(partitionColumn);
            partitionColumn.setQuotedFunc(func);
            String tableAlias = partitionColumn.getTableAlias();
            String concatField = String.format(Locale.ROOT, "CONCAT(%s.YEAR,'-',%s.MONTH,'-',%s.DAY)", tableAlias, tableAlias, tableAlias);
            StringBuilder builder = new StringBuilder();
            if (startInclusive > 0L) {
                builder.append(concatField + " >= '" + DateFormat.formatToDateStr(startInclusive) + "' ");
                builder.append("AND ");
            }
            builder.append(concatField + " < '" + DateFormat.formatToDateStr(endExclusive) + "'");
            return builder.toString();
        }
    }

    public static class DefaultPartitionConditionBuilder
    implements IPartitionConditionBuilder,
    Serializable {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, ISegment seg, SegmentRange segRange, Function<TblColRef, String> quoteFunc) {
            long startInclusive = (Long)segRange.start.v;
            long endExclusive = (Long)segRange.end.v;
            TblColRef partitionDateColumn = partDesc.getPartitionDateColumnRef();
            TblColRef partitionTimeColumn = partDesc.getPartitionTimeColumnRef();
            if (partitionDateColumn != null) {
                partitionDateColumn.setQuotedFunc(quoteFunc);
            }
            if (partitionTimeColumn != null) {
                partitionTimeColumn.setQuotedFunc(quoteFunc);
            }
            StringBuilder builder = new StringBuilder();
            if (partDesc.partitionColumnIsYmdInt()) {
                if (partitionTimeColumn == null) {
                    DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmdInt(builder, partitionDateColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat());
                } else {
                    DefaultPartitionConditionBuilder.buildMultipleColumnRangeCondition(builder, partitionDateColumn, partitionTimeColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat(), partDesc.getPartitionTimeFormat(), true);
                }
            } else if (partDesc.partitionColumnIsTimeMillis()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsTimeMillis(builder, partitionDateColumn, startInclusive, endExclusive);
            } else if (partitionDateColumn != null && partitionTimeColumn == null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionDateColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat());
            } else if (partitionDateColumn == null && partitionTimeColumn != null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionTimeColumn, startInclusive, endExclusive, partDesc.getPartitionTimeFormat());
            } else if (partitionDateColumn != null && partitionTimeColumn != null) {
                DefaultPartitionConditionBuilder.buildMultipleColumnRangeCondition(builder, partitionDateColumn, partitionTimeColumn, startInclusive, endExclusive, partDesc.getPartitionDateFormat(), partDesc.getPartitionTimeFormat(), false);
            }
            return builder.toString();
        }

        private static void buildSingleColumnRangeCondAsTimeMillis(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive) {
            String partitionColumnName = partitionColumn.getQuotedIdentity();
            builder.append(partitionColumnName + " >= " + startInclusive);
            builder.append(" AND ");
            builder.append(partitionColumnName + " < " + endExclusive);
        }

        private static void buildSingleColumnRangeCondAsYmdInt(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat) {
            String partitionColumnName = partitionColumn.getQuotedIdentity();
            builder.append(partitionColumnName + " >= " + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat));
            builder.append(" AND ");
            builder.append(partitionColumnName + " < " + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat));
        }

        private static void buildSingleColumnRangeCondition(StringBuilder builder, TblColRef partitionColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat) {
            String partitionColumnName = partitionColumn.getQuotedIdentity();
            if (endExclusive <= startInclusive) {
                builder.append("1=0");
                return;
            }
            String startInc = null;
            String endInc = null;
            if (StringUtils.isBlank(partitionColumnDateFormat)) {
                startInc = String.valueOf(startInclusive);
                endInc = String.valueOf(endExclusive);
            } else {
                startInc = DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat);
                endInc = DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat);
            }
            builder.append(partitionColumnName + " >= '" + startInc + "'");
            builder.append(" AND ");
            builder.append(partitionColumnName + " < '" + endInc + "'");
        }

        private static void buildMultipleColumnRangeCondition(StringBuilder builder, TblColRef partitionDateColumn, TblColRef partitionTimeColumn, long startInclusive, long endExclusive, String partitionColumnDateFormat, String partitionColumnTimeFormat, boolean partitionDateColumnIsYmdInt) {
            String partitionDateColumnName = partitionDateColumn.getQuotedIdentity();
            String partitionTimeColumnName = partitionTimeColumn.getQuotedIdentity();
            String singleQuotation = partitionDateColumnIsYmdInt ? "" : "'";
            builder.append("(");
            builder.append("(");
            builder.append(partitionDateColumnName + " = " + singleQuotation + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + singleQuotation).append(" AND ").append(partitionTimeColumnName + " >= '" + DateFormat.formatToDateStr(startInclusive, partitionColumnTimeFormat) + "'");
            builder.append(")");
            builder.append(" OR ");
            builder.append("(");
            builder.append(partitionDateColumnName + " > " + singleQuotation + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + singleQuotation);
            builder.append(")");
            builder.append(")");
            builder.append(" AND ");
            builder.append("(");
            builder.append("(");
            builder.append(partitionDateColumnName + " = " + singleQuotation + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + singleQuotation).append(" AND ").append(partitionTimeColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnTimeFormat) + "'");
            builder.append(")");
            builder.append(" OR ");
            builder.append("(");
            builder.append(partitionDateColumnName + " < " + singleQuotation + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + singleQuotation);
            builder.append(")");
            builder.append(")");
        }
    }

    public static interface IPartitionConditionBuilder {
        public String buildDateRangeCondition(PartitionDesc var1, ISegment var2, SegmentRange var3, Function<TblColRef, String> var4);
    }

    public static enum PartitionType implements Serializable
    {
        APPEND,
        UPDATE_INSERT;

    }
}

