/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ParameterDesc
implements Serializable {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="next_parameter")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ParameterDesc nextParameter;
    private TblColRef colRef = null;
    private List<TblColRef> allColRefsIncludingNexts = null;
    private Set<PlainParameter> plainParameters = null;

    public static ParameterDesc newInstance(Object ... objs) {
        if (objs.length == 0) {
            throw new IllegalArgumentException();
        }
        ParameterDesc r = new ParameterDesc();
        Object obj = objs[0];
        if (obj instanceof TblColRef) {
            TblColRef col = (TblColRef)obj;
            r.type = "column";
            r.value = col.getIdentity();
            r.colRef = col;
        } else {
            r.type = "constant";
            r.value = (String)obj;
        }
        if (objs.length >= 2) {
            r.nextParameter = ParameterDesc.newInstance(Arrays.copyOfRange(objs, 1, objs.length));
        }
        return r;
    }

    public Set<PlainParameter> getPlainParameters() {
        if (this.plainParameters == null) {
            this.plainParameters = PlainParameter.createFromParameterDesc(this);
        }
        return this.plainParameters;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.value.getBytes("UTF-8");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TblColRef getColRef() {
        return this.colRef;
    }

    void setColRef(TblColRef colRef) {
        this.colRef = colRef;
    }

    public List<TblColRef> getColRefs() {
        if (this.allColRefsIncludingNexts == null) {
            ArrayList<TblColRef> all = new ArrayList<TblColRef>(2);
            ParameterDesc p = this;
            while (p != null) {
                if (p.isColumnType()) {
                    all.add(p.getColRef());
                }
                p = p.nextParameter;
            }
            this.allColRefsIncludingNexts = all;
        }
        return this.allColRefsIncludingNexts;
    }

    public ParameterDesc getNextParameter() {
        return this.nextParameter;
    }

    public boolean isColumnType() {
        return "column".equals(this.type.toLowerCase(Locale.ROOT));
    }

    public boolean isConstant() {
        return "constant".equals(this.type.toLowerCase(Locale.ROOT));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDesc that = (ParameterDesc)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        ParameterDesc p = this;
        ParameterDesc q = that;
        while (p != null && q != null) {
            if (p.isColumnType()) {
                if (!q.isColumnType()) {
                    return false;
                }
                if (q.getColRef() != null && !q.getColRef().equals(p.getColRef())) {
                    return false;
                }
                if (!q.getType().equals(p.getType()) || !q.getValue().equals(q.getValue())) {
                    return false;
                }
            } else {
                if (q.isColumnType()) {
                    return false;
                }
                if (!p.value.equals(q.value)) {
                    return false;
                }
            }
            p = p.nextParameter;
            q = q.nextParameter;
        }
        return p == null && q == null;
    }

    public boolean equalInArbitraryOrder(Object o) {
        Set<PlainParameter> thatPlainParams;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDesc that = (ParameterDesc)o;
        Set<PlainParameter> thisPlainParams = this.getPlainParameters();
        return thisPlainParams.containsAll(thatPlainParams = that.getPlainParameters()) && thatPlainParams.containsAll(thisPlainParams);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.colRef != null ? this.colRef.hashCode() : 0);
        return result;
    }

    public String toString() {
        String tmp = null;
        tmp = this.isColumnType() && this.colRef != null ? this.colRef.toString() : this.value;
        return this.nextParameter == null ? tmp : tmp + "," + this.nextParameter.toString();
    }

    private static class PlainParameter {
        private String type;
        private String value;
        private TblColRef colRef = null;

        private PlainParameter() {
        }

        public boolean isColumnType() {
            return "column".equals(this.type);
        }

        static Set<PlainParameter> createFromParameterDesc(ParameterDesc parameterDesc) {
            HashSet<PlainParameter> result = Sets.newHashSet();
            ParameterDesc local = parameterDesc;
            while (local != null) {
                if (local.isColumnType()) {
                    result.add(PlainParameter.createSingleColumnParameter(local));
                } else {
                    result.add(PlainParameter.createSingleValueParameter(local));
                }
                local = local.nextParameter;
            }
            return result;
        }

        static PlainParameter createSingleValueParameter(ParameterDesc parameterDesc) {
            PlainParameter single = new PlainParameter();
            single.type = parameterDesc.type;
            single.value = parameterDesc.value;
            return single;
        }

        static PlainParameter createSingleColumnParameter(ParameterDesc parameterDesc) {
            PlainParameter single = new PlainParameter();
            single.type = parameterDesc.type;
            single.value = parameterDesc.value;
            single.colRef = parameterDesc.colRef;
            return single;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.colRef != null ? this.colRef.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlainParameter that = (PlainParameter)o;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            if (this.isColumnType()) {
                if (!that.isColumnType()) {
                    return false;
                }
                if (!this.colRef.equals(that.colRef)) {
                    return false;
                }
            } else {
                if (that.isColumnType()) {
                    return false;
                }
                if (!this.value.equals(that.value)) {
                    return false;
                }
            }
            return true;
        }
    }
}

