/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class JoinsTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final IJoinDescMatcher DEFAULT_JOINDESC_MATCHER = new DefaultJoinDescMatcher();
    private Map<String, Chain> tableChains = new LinkedHashMap<String, Chain>();
    private IJoinDescMatcher joinDescMatcher = DEFAULT_JOINDESC_MATCHER;

    public JoinsTree(TableRef rootTable, List<JoinDesc> joins) {
        for (JoinDesc join2 : joins) {
            for (TblColRef col : join2.getForeignKeyColumns()) {
                Preconditions.checkState(col.isQualified());
            }
            for (TblColRef col : join2.getPrimaryKeyColumns()) {
                Preconditions.checkState(col.isQualified());
            }
        }
        this.tableChains.put(rootTable.getAlias(), new Chain(rootTable, null, null));
        for (JoinDesc join2 : joins) {
            TableRef pkSide = join2.getPKSide();
            Chain fkSide = this.tableChains.get(join2.getFKSide().getAlias());
            this.tableChains.put(pkSide.getAlias(), new Chain(pkSide, join2, fkSide));
        }
    }

    public JoinsTree(Map<String, Chain> tableChains) {
        this.tableChains = tableChains;
    }

    public Map<String, String> matches(JoinsTree another) {
        return this.matches(another, Collections.emptyMap());
    }

    public Map<String, String> matches(JoinsTree another, Map<String, String> constraints) {
        HashMap<String, String> matchUp = new HashMap<String, String>();
        for (Chain chain : this.tableChains.values()) {
            if (this.matchInTree(chain, another, constraints, matchUp)) continue;
            return null;
        }
        return matchUp;
    }

    public int matchNum(JoinsTree another) {
        HashMap<String, String> matchUp = new HashMap<String, String>();
        for (Chain chain : this.tableChains.values()) {
            this.matchInTree(chain, another, Collections.emptyMap(), matchUp);
        }
        return matchUp.size();
    }

    private boolean matchInTree(Chain chain, JoinsTree another, Map<String, String> constraints, Map<String, String> matchUp) {
        String thisAlias = chain.table.getAlias();
        if (matchUp.containsKey(thisAlias)) {
            return true;
        }
        String constraint = constraints.get(thisAlias);
        if (constraint != null) {
            return this.matchChain(chain, another.tableChains.get(constraint), matchUp);
        }
        for (Chain anotherChain : another.tableChains.values()) {
            if (!this.matchChain(chain, anotherChain, matchUp)) continue;
            return true;
        }
        return false;
    }

    private boolean matchChain(Chain chain, Chain anotherChain, Map<String, String> matchUp) {
        String thisAlias = chain.table.getAlias();
        String anotherAlias = anotherChain.table.getAlias();
        String curMatch = matchUp.get(thisAlias);
        if (curMatch != null) {
            return curMatch.equals(anotherAlias);
        }
        if (curMatch == null && matchUp.values().contains(anotherAlias)) {
            return false;
        }
        boolean matches = false;
        if (chain.join == null) {
            matches = anotherChain.join == null && chain.table.getTableDesc().getIdentity().equals(anotherChain.table.getTableDesc().getIdentity());
        } else {
            boolean bl = matches = this.joinDescMatcher.matches(chain.join, anotherChain.join) && this.matchChain(chain.fkSide, anotherChain.fkSide, matchUp);
        }
        if (matches) {
            matchUp.put(thisAlias, anotherAlias);
        }
        return matches;
    }

    public JoinDesc getJoinByPKSide(TableRef table) {
        Chain chain = this.tableChains.get(table.getAlias());
        if (chain == null) {
            return null;
        }
        return chain.join;
    }

    public List<Chain> unmatchedChain(JoinsTree another, Map<String, String> constraints) {
        HashMap<String, String> matchUp = new HashMap<String, String>();
        ArrayList<Chain> unmatchedChainList = Lists.newArrayList();
        for (Chain chain : this.tableChains.values()) {
            if (this.matchInTree(chain, another, constraints, matchUp)) continue;
            unmatchedChainList.add(chain);
        }
        return unmatchedChainList;
    }

    public Map<String, Chain> getTableChains() {
        return this.tableChains;
    }

    public void setJoinDescMatcher(IJoinDescMatcher joinDescMatcher) {
        this.joinDescMatcher = joinDescMatcher;
    }

    public JoinsTree getSubgraphByAlias(Set<String> aliases) {
        HashMap<String, Chain> subgraph = Maps.newHashMap();
        for (String alias : aliases) {
            Chain chain = this.tableChains.get(alias);
            if (chain == null) {
                throw new IllegalArgumentException("Table with alias " + alias + " is not found");
            }
            while (chain.getFkSide() != null) {
                subgraph.put(chain.table.getAlias(), chain);
                chain = chain.getFkSide();
            }
            subgraph.put(chain.table.getAlias(), chain);
        }
        return new JoinsTree(subgraph);
    }

    public static class DefaultJoinDescMatcher
    implements IJoinDescMatcher,
    Serializable {
        @Override
        public boolean matches(JoinDesc join1, JoinDesc join2) {
            if (join1 == null) {
                return join2 == null;
            }
            if (join2 == null) {
                return false;
            }
            if (!join1.getType().equalsIgnoreCase(join2.getType())) {
                return false;
            }
            if (!this.columnDescEquals(join1.getForeignKeyColumns(), join2.getForeignKeyColumns())) {
                return false;
            }
            return this.columnDescEquals(join1.getPrimaryKeyColumns(), join2.getPrimaryKeyColumns());
        }

        private boolean columnDescEquals(TblColRef[] a, TblColRef[] b) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (this.columnDescEquals(a[i].getColumnDesc(), b[i].getColumnDesc())) continue;
                return false;
            }
            return true;
        }

        protected boolean columnDescEquals(ColumnDesc a, ColumnDesc b) {
            return a == null ? b == null : a.equals(b);
        }
    }

    public static interface IJoinDescMatcher {
        public boolean matches(JoinDesc var1, JoinDesc var2);
    }

    public static class Chain
    implements Serializable {
        private static final long serialVersionUID = 1L;
        TableRef table;
        JoinDesc join;
        Chain fkSide;

        public Chain(TableRef table, JoinDesc join2, Chain fkSide) {
            this.table = table;
            this.join = join2;
            this.fkSide = fkSide;
            if (join2 != null) {
                Preconditions.checkArgument(table == join2.getPKSide());
                Preconditions.checkArgument(fkSide.table == join2.getFKSide());
            }
        }

        public JoinDesc getJoin() {
            return this.join;
        }

        public TableRef getTable() {
            return this.table;
        }

        public Chain getFkSide() {
            return this.fkSide;
        }
    }
}

