/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class TimeConditionLiteralsReplacer
implements TupleFilterSerializer.Decorator {
    private IdentityHashMap<TupleFilter, DataType> dateCompareTupleChildren = Maps.newIdentityHashMap();

    public TimeConditionLiteralsReplacer(TupleFilter root) {
    }

    @Override
    public TupleFilter onSerialize(TupleFilter filter2) {
        if (filter2 instanceof CompareTupleFilter) {
            CompareTupleFilter cfilter = (CompareTupleFilter)filter2;
            List<? extends TupleFilter> children = cfilter.getChildren();
            if (children == null || children.size() < 1) {
                throw new IllegalArgumentException("Illegal compare filter: " + cfilter);
            }
            TblColRef col = cfilter.getColumn();
            if (col == null || !col.getType().isDateTimeFamily()) {
                return cfilter;
            }
            for (TupleFilter tupleFilter : filter2.getChildren()) {
                this.dateCompareTupleChildren.put(tupleFilter, col.getType());
            }
        }
        if (filter2 instanceof ConstantTupleFilter && this.dateCompareTupleChildren.containsKey(filter2)) {
            ConstantTupleFilter constantTupleFilter = (ConstantTupleFilter)filter2;
            HashSet<String> newValues = Sets.newHashSet();
            DataType columnType = this.dateCompareTupleChildren.get(filter2);
            for (String string : constantTupleFilter.getValues()) {
                newValues.add(this.formatTime(string, columnType));
            }
            return new ConstantTupleFilter(newValues);
        }
        return filter2;
    }

    private String formatTime(String dateStr, DataType dataType) {
        if (dataType.isDatetime() || dataType.isTime()) {
            throw new RuntimeException("Datetime and time type are not supported yet");
        }
        if (DateFormat.isSupportedDateFormat(dateStr)) {
            return dateStr;
        }
        long millis = Long.parseLong(dateStr);
        if (dataType.isTimestamp()) {
            return DateFormat.formatToTimeStr(millis);
        }
        if (dataType.isDate()) {
            return DateFormat.formatToDateStr(millis);
        }
        throw new RuntimeException("Unknown type " + dataType + " to formatTime");
    }
}

