/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kylin.common.util.DecimalUtil;
import org.apache.kylin.metadata.datatype.BigDecimalSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class NumberTupleExpression
extends TupleExpression {
    public static final BigDecimalSerializer serializer = new BigDecimalSerializer(DataType.getType("decimal"));
    private BigDecimal value;

    public NumberTupleExpression(Object value) {
        this(DecimalUtil.toBigDecimal(value));
    }

    public NumberTupleExpression(BigDecimal value) {
        super(TupleExpression.ExpressionOperatorEnum.NUMBER, Collections.emptyList());
        this.value = value;
    }

    @Override
    public void verify() {
    }

    @Override
    public BigDecimal calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return this.value;
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitNumber(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        serializer.serialize(this.value, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        this.value = serializer.deserialize(buffer);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberTupleExpression that = (NumberTupleExpression)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

