/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.curator;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.ServiceCacheListener;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.ServerMode;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.common.util.ZKUtil;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.impl.curator.CuratorLeaderSelector;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorScheduler
implements Scheduler<AbstractExecutable> {
    private static final Logger logger = LoggerFactory.getLogger(CuratorScheduler.class);
    private boolean started = false;
    private CuratorFramework curatorClient = null;
    private static CuratorLeaderSelector jobClient = null;
    private ServiceDiscovery<LinkedHashMap> serviceDiscovery = null;
    private ServiceCache<LinkedHashMap> serviceCache = null;
    private KylinConfig kylinConfig;
    private AtomicInteger count = new AtomicInteger();
    static final String JOB_ENGINE_LEADER_PATH = "/job_engine/leader";
    static final String KYLIN_SERVICE_PATH = "/service";
    static final String SERVICE_NAME = "kylin";
    static final String SERVICE_PAYLOAD_DESCRIPTION = "description";

    public CuratorScheduler() {
    }

    @VisibleForTesting
    CuratorScheduler(CuratorFramework curatorClient) {
        this.curatorClient = curatorClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(JobEngineConfig jobEngineConfig, JobLock jobLock) throws SchedulerException {
        this.kylinConfig = jobEngineConfig.getConfig();
        CuratorScheduler curatorScheduler = this;
        synchronized (curatorScheduler) {
            if (this.started) {
                logger.info("CuratorScheduler already started, skipped.");
                return;
            }
            if (this.curatorClient == null) {
                this.curatorClient = ZKUtil.getZookeeperClient(this.kylinConfig);
            }
            String serverMode = jobEngineConfig.getConfig().getServerMode();
            String restAddress = this.kylinConfig.getServerRestAddress();
            try {
                this.registerInstance(restAddress, serverMode);
            }
            catch (Exception e) {
                throw new SchedulerException(e);
            }
            String jobEnginePath = JOB_ENGINE_LEADER_PATH;
            if (ServerMode.isJob(jobEngineConfig.getConfig())) {
                jobClient = new CuratorLeaderSelector(this.curatorClient, jobEnginePath, restAddress, jobEngineConfig);
                try {
                    logger.info("start Job Engine, lock path is: " + jobEnginePath);
                    jobClient.start();
                    this.monitorJobEngine();
                }
                catch (IOException e) {
                    throw new SchedulerException(e);
                }
            } else {
                logger.info("server mode: " + jobEngineConfig.getConfig().getServerMode() + ", no need to run job scheduler");
            }
            this.started = true;
        }
    }

    private void registerInstance(String restAddress, String mode) throws Exception {
        String host = restAddress.substring(0, restAddress.indexOf(":"));
        String port = restAddress.substring(restAddress.indexOf(":") + 1);
        JsonInstanceSerializer<LinkedHashMap> serializer = new JsonInstanceSerializer<LinkedHashMap>(LinkedHashMap.class);
        String servicePath = KYLIN_SERVICE_PATH;
        this.serviceDiscovery = ServiceDiscoveryBuilder.builder(LinkedHashMap.class).client(this.curatorClient).basePath(KYLIN_SERVICE_PATH).serializer(serializer).build();
        this.serviceDiscovery.start();
        this.serviceCache = this.serviceDiscovery.serviceCacheBuilder().name(SERVICE_NAME).threadFactory(Executors.defaultThreadFactory()).build();
        this.serviceCache.addListener((Object)new ServiceCacheListener(){

            public void stateChanged(CuratorFramework curatorFramework, ConnectionState connectionState) {
            }

            public void cacheChanged() {
                logger.info("Service discovery get cacheChanged notification");
                List instances = CuratorScheduler.this.serviceCache.getInstances();
                List<String> instanceNodes = Lists.transform(instances, new Function<ServiceInstance<LinkedHashMap>, String>(){

                    @Override
                    @Nullable
                    public String apply(@Nullable ServiceInstance<LinkedHashMap> stringServiceInstance) {
                        return (String)((LinkedHashMap)stringServiceInstance.getPayload()).get(CuratorScheduler.SERVICE_PAYLOAD_DESCRIPTION);
                    }
                });
                String restServersInCluster = StringUtil.join(instanceNodes.stream().map(input -> {
                    String[] split = input.split(":");
                    return split[0] + ":" + split[1];
                }).collect(Collectors.toList()), ",");
                logger.info("kylin.server.cluster-servers update to " + restServersInCluster);
                System.setProperty("kylin.server.cluster-servers", restServersInCluster);
                String restServersInClusterWithMode = StringUtil.join(instanceNodes, ",");
                logger.info("kylin.server.cluster-servers-with-mode update to " + restServersInClusterWithMode);
                System.setProperty("kylin.server.cluster-servers-with-mode", restServersInClusterWithMode);
            }
        });
        this.serviceCache.start();
        LinkedHashMap<String, String> instanceDetail = new LinkedHashMap<String, String>();
        instanceDetail.put(SERVICE_PAYLOAD_DESCRIPTION, restAddress + ":" + mode);
        ServiceInstance thisInstance = ServiceInstance.builder().name(SERVICE_NAME).payload(instanceDetail).port(Integer.valueOf(port).intValue()).address(host).build();
        for (ServiceInstance instance : this.serviceCache.getInstances()) {
            if (!instance.getAddress().equals(thisInstance.getAddress()) || !instance.getPort().equals(thisInstance.getPort())) continue;
            this.serviceDiscovery.unregisterService(instance);
        }
        this.serviceDiscovery.registerService(thisInstance);
    }

    private void monitorJobEngine() {
        logger.info("Start collect monitor ZK Participants");
        CuratorScheduler curatorScheduler = this;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean hasLeadership = jobClient.hasLeadership();
                    boolean hasDefaultSchedulerStarted = jobClient.hasDefaultSchedulerStarted();
                    if (hasLeadership != hasDefaultSchedulerStarted) {
                        logger.error("Node(" + InetAddress.getLocalHost().getHostAddress() + ") job server state conflict. Is ZK leader: " + hasLeadership + "; Is active job server: " + hasDefaultSchedulerStarted);
                    }
                    if (CuratorScheduler.this.count.incrementAndGet() == 10) {
                        logger.info("Current Participants: " + jobClient.getParticipants());
                        CuratorScheduler.this.count.set(0);
                    }
                }
                catch (Throwable th) {
                    logger.error("Error when getting JVM info.", th);
                }
            }
        }, 3L, curatorScheduler.kylinConfig.getInstanceFromEnv().getZKMonitorInterval(), TimeUnit.SECONDS);
    }

    @Override
    public void shutdown() throws SchedulerException {
        IOUtils.closeQuietly(this.serviceCache);
        IOUtils.closeQuietly(this.serviceDiscovery);
        IOUtils.closeQuietly((Closeable)this.curatorClient);
        IOUtils.closeQuietly(jobClient);
        this.started = false;
    }

    public static String slickMetadataPrefix(String metadataPrefix) {
        if (metadataPrefix.indexOf("/") >= 0) {
            if (metadataPrefix.endsWith("/")) {
                metadataPrefix = metadataPrefix.substring(0, metadataPrefix.length() - 2);
            }
            return metadataPrefix.substring(metadataPrefix.lastIndexOf("/") + 1);
        }
        return metadataPrefix;
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    public static CuratorLeaderSelector getLeaderSelector() {
        return jobClient;
    }

    static class JsonInstanceSerializer<T>
    implements InstanceSerializer<T> {
        private final ObjectMapper mapper;
        private final Class<T> payloadClass;
        private final JavaType type;

        JsonInstanceSerializer(Class<T> payloadClass) {
            this.payloadClass = payloadClass;
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.type = this.mapper.getTypeFactory().constructType((Type)((Object)ServiceInstance.class));
        }

        public ServiceInstance<T> deserialize(byte[] bytes) throws Exception {
            ServiceInstance rawServiceInstance = (ServiceInstance)this.mapper.readValue(bytes, this.type);
            this.payloadClass.cast(rawServiceInstance.getPayload());
            return rawServiceInstance;
        }

        public byte[] serialize(ServiceInstance<T> instance) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.mapper.convertValue(instance.getPayload(), this.payloadClass);
            this.mapper.writeValue(out, instance);
            return out.toByteArray();
        }
    }
}

