/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.Executable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointExecutable
extends DefaultChainedExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointExecutable.class);
    public static final Integer DEFAULT_PRIORITY = 30;
    private static final String DEPLOY_ENV_NAME = "envName";
    private static final String PROJECT_INSTANCE_NAME = "projectName";
    private final List<AbstractExecutable> subTasksForCheck = Lists.newArrayList();

    public void addTaskForCheck(AbstractExecutable executable) {
        this.subTasksForCheck.add(executable);
    }

    public void addTaskListForCheck(List<AbstractExecutable> executableList) {
        this.subTasksForCheck.addAll(executableList);
    }

    public List<AbstractExecutable> getSubTasksForCheck() {
        return this.subTasksForCheck;
    }

    @Override
    public boolean isReady() {
        if (!super.isReady()) {
            return false;
        }
        for (Executable executable : this.subTasksForCheck) {
            Output output = this.getManager().getOutput(executable.getId());
            if (output.getState() == ExecutableState.SUCCEED) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void onExecuteFinished(ExecuteResult result, ExecutableContext executableContext) {
        super.onExecuteFinished(result, executableContext);
        if (!this.isDiscarded() && result.succeed()) {
            List<AbstractExecutable> jobs = this.getTasks();
            boolean allSucceed = true;
            for (Executable executable : jobs) {
                ExecutableState status = executable.getStatus();
                if (status == ExecutableState.SUCCEED) continue;
                allSucceed = false;
            }
            if (allSucceed) {
                CubeManager cubeManager = CubeManager.getInstance(executableContext.getConfig());
                CubeInstance cubeInstance = cubeManager.getCube(this.getCubeName());
                CubeInstance copyForWrite = cubeInstance.latestCopyForWrite();
                try {
                    copyForWrite.setCuboidLastOptimized(this.getEndTime());
                    CubeUpdate cubeUpdate = new CubeUpdate(copyForWrite);
                    cubeManager.updateCube(cubeUpdate);
                }
                catch (IOException e) {
                    logger.error("Failed to update last optimized for " + this.getCubeName(), e);
                }
            }
        }
    }

    public String getDeployEnvName() {
        return this.getParam(DEPLOY_ENV_NAME);
    }

    public void setDeployEnvName(String name) {
        this.setParam(DEPLOY_ENV_NAME, name);
    }

    @Override
    public String getProjectName() {
        return this.getParam(PROJECT_INSTANCE_NAME);
    }

    @Override
    public void setProjectName(String name) {
        this.setParam(PROJECT_INSTANCE_NAME, name);
    }

    @Override
    public int getDefaultPriority() {
        return DEFAULT_PRIORITY;
    }
}

