/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;

public class PatternedLogger
extends BufferedLogger {
    private final Map<String, String> info = Maps.newHashMap();
    private ILogListener listener = null;
    private static final Pattern PATTERN_APP_ID = Pattern.compile("Submitted application (.*?) to ResourceManager");
    private static final Pattern PATTERN_APP_URL = Pattern.compile("The url to track the job: (.*)");
    private static final Pattern PATTERN_JOB_ID = Pattern.compile("Running job: (.*)");
    private static final Pattern PATTERN_HDFS_BYTES_WRITTEN = Pattern.compile("(?:HD|MAPR)FS: Number of bytes written=(\\d+)");
    private static final Pattern PATTERN_SOURCE_RECORDS_COUNT = Pattern.compile("Map input records=(\\d+)");
    private static final Pattern PATTERN_SOURCE_RECORDS_SIZE = Pattern.compile("(?:HD|MAPR)FS Read: (\\d+) (?:HD|MAPR)FS Write");
    private static final Pattern PATTERN_HIVE_APP_ID_URL = Pattern.compile("Starting Job = (.*?), Tracking URL = (.*)");
    private static final Pattern PATTERN_HIVE_BYTES_WRITTEN = Pattern.compile("(?:HD|MAPR)FS Read: (\\d+) (?:HD|MAPR)FS Write: (\\d+) SUCCESS");
    private static final Pattern PATTERN_HIVE_APP_ID_URL_2 = Pattern.compile("Executing on YARN cluster with App id  (.*?)");
    private static final Pattern PATTERN_SPARK_APP_ID = Pattern.compile("Submitted application (.*)");
    private static final Pattern PATTERN_SPARK_APP_URL = Pattern.compile("tracking URL: (.*)");
    private static final Pattern PATTERN_JOB_STATE = Pattern.compile("Final-State : (.*?)$");
    private static final Pattern PATTERN_FLINK_APP_ID = Pattern.compile("Submitted application (.*)");
    private static final Pattern PATTERN_FLINK_APP_URL = Pattern.compile("tracking URL: (.*)");
    private static Map<Pattern, Pair<String, Integer>> patternMap = Maps.newHashMap();

    public PatternedLogger(Logger wrappedLogger) {
        super(wrappedLogger);
    }

    public PatternedLogger(Logger wrappedLogger, ILogListener listener) {
        super(wrappedLogger);
        this.listener = listener;
    }

    @Override
    public void log(String message) {
        super.log(message);
        for (Pattern pattern : patternMap.keySet()) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) continue;
            String key = patternMap.get(pattern).getFirst();
            int index = patternMap.get(pattern).getSecond();
            String value = matcher.group(index);
            this.info.put(key, value);
            if (this.listener == null) break;
            this.listener.onLogEvent(key, this.info);
            break;
        }
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setILogListener(ILogListener listener) {
        this.listener = listener;
    }

    static {
        patternMap.put(PATTERN_APP_ID, new Pair<String, Integer>("yarn_application_id", 1));
        patternMap.put(PATTERN_APP_URL, new Pair<String, Integer>("yarn_application_tracking_url", 1));
        patternMap.put(PATTERN_JOB_ID, new Pair<String, Integer>("mr_job_id", 1));
        patternMap.put(PATTERN_HDFS_BYTES_WRITTEN, new Pair<String, Integer>("hdfs_bytes_written", 1));
        patternMap.put(PATTERN_SOURCE_RECORDS_COUNT, new Pair<String, Integer>("source_records_count", 1));
        patternMap.put(PATTERN_SOURCE_RECORDS_SIZE, new Pair<String, Integer>("source_records_size", 1));
        patternMap.put(PATTERN_HIVE_APP_ID_URL, new Pair<String, Integer>("yarn_application_tracking_url", 2));
        patternMap.put(PATTERN_HIVE_APP_ID_URL_2, new Pair<String, Integer>("yarn_application_tracking_url", 1));
        patternMap.put(PATTERN_HIVE_BYTES_WRITTEN, new Pair<String, Integer>("hdfs_bytes_written", 2));
        patternMap.put(PATTERN_SPARK_APP_ID, new Pair<String, Integer>("spark_job_id", 1));
        patternMap.put(PATTERN_SPARK_APP_URL, new Pair<String, Integer>("yarn_application_tracking_url", 1));
        patternMap.put(PATTERN_JOB_STATE, new Pair<String, Integer>("yarn_application_state", 1));
        patternMap.put(PATTERN_FLINK_APP_ID, new Pair<String, Integer>("flink_job_id", 1));
        patternMap.put(PATTERN_FLINK_APP_URL, new Pair<String, Integer>("yarn_application_tracking_url", 1));
    }

    public static interface ILogListener {
        public void onLogEvent(String var1, Map<String, String> var2);
    }
}

