/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

public class JoinedFormatter {
    private static final String REG_SEPARATOR = "\\$\\{(?<KEY>.*?)\\}";
    private static final Pattern REG_PATTERN = Pattern.compile("\\$\\{(?<KEY>.*?)\\}", 34);
    private static final String START_DATE = "START_DATE";
    private static final String END_DATE = "END_DATE";
    private static final String ENV_KEY = "KEY";
    private Map<String, Object> mapEnv = new HashMap<String, Object>();

    JoinedFormatter() {
    }

    JoinedFormatter(IJoinedFlatTableDesc flatDesc) {
        this.setDateEnv(flatDesc);
    }

    private void setDateEnv(IJoinedFlatTableDesc flatDesc) {
        DataModelDesc model = flatDesc.getDataModel();
        PartitionDesc partDesc = model.getPartitionDesc();
        SegmentRange segRange = flatDesc.getSegRange();
        long startInclusive = (Long)segRange.start.v;
        long endExclusive = (Long)segRange.end.v;
        String startDate = "";
        String endDate = "";
        String partitionColumnDateFormat = partDesc.getPartitionDateFormat();
        if (partDesc.getPartitionTimeColumn() == null && partDesc.getPartitionDateColumn() == null) {
            startDate = String.valueOf(startInclusive);
            endDate = String.valueOf(endExclusive);
        } else {
            startDate = DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat);
            endDate = DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat);
        }
        this.setKeyValue(START_DATE, startDate);
        this.setKeyValue(END_DATE, endDate);
    }

    public Object getValue(String key) {
        String fmtKey = StringUtils.trimToEmpty(key).toUpperCase(Locale.ROOT);
        Object value = this.mapEnv.get(fmtKey);
        return value == null ? "" : value;
    }

    String formatSentence(String sentence) {
        String[] cArray = REG_PATTERN.split(sentence);
        StringBuilder sbr = new StringBuilder();
        List<String> keys = this.getKeys(sentence);
        int length = Math.max(cArray.length, keys.size());
        for (int i = 0; i < length; ++i) {
            if (i < cArray.length) {
                sbr.append(cArray[i]);
            }
            if (i >= keys.size()) continue;
            sbr.append(this.getValue(keys.get(i)));
        }
        return sbr.toString();
    }

    private List<String> getKeys(String condition) {
        ArrayList<String> keys = new ArrayList<String>();
        Matcher matcher = REG_PATTERN.matcher(condition);
        while (matcher.find()) {
            keys.add(matcher.group(ENV_KEY));
        }
        return keys;
    }

    private void setKeyValue(String key, Object value) {
        String fmtKey = StringUtils.trimToEmpty(key).toUpperCase(Locale.ROOT);
        this.mapEnv.put(fmtKey, value);
    }

    void setStartDate(String dateStr) {
        this.setKeyValue(START_DATE, dateStr);
    }

    void setEndDate(String dateStr) {
        this.setKeyValue(END_DATE, dateStr);
    }

    void printEnv() {
        System.out.println(this.mapEnv);
    }
}

