/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.sql.SqlDialect;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.job.JoinedFormatter;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.util.FlatTableSqlQuoteUtils;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;

public class JoinedFlatTable {
    public static final String TEXTFILE = "TEXTFILE";
    public static final String SEQUENCEFILE = "SEQUENCEFILE";

    public static String getTableDir(IJoinedFlatTableDesc flatDesc, String storageDfsDir) {
        return storageDfsDir + "/" + flatDesc.getTableName();
    }

    public static String generateHiveInitStatements(String flatTableDatabase) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("USE ").append(flatTableDatabase).append(";\n");
        return buffer.toString();
    }

    public static String generateCreateTableStatement(IJoinedFlatTableDesc flatDesc, String storageDfsDir) {
        String storageFormat = flatDesc.getSegment().getConfig().getFlatTableStorageFormat();
        return JoinedFlatTable.generateCreateTableStatement(flatDesc, storageDfsDir, storageFormat);
    }

    public static String generateCreateTableStatement(IJoinedFlatTableDesc flatDesc, String storageDfsDir, String storageFormat) {
        String fieldDelimiter = flatDesc.getDataModel().getConfig().getFlatTableFieldDelimiter();
        return JoinedFlatTable.generateCreateTableStatement(flatDesc, storageDfsDir, storageFormat, fieldDelimiter);
    }

    public static String generateCreateTableStatement(IJoinedFlatTableDesc flatDesc, String storageDfsDir, String storageFormat, String fieldDelimiter) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE EXTERNAL TABLE IF NOT EXISTS " + flatDesc.getTableName() + "\n");
        ddl.append("(\n");
        for (int i = 0; i < flatDesc.getAllColumns().size(); ++i) {
            TblColRef col = flatDesc.getAllColumns().get(i);
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(FlatTableSqlQuoteUtils.quoteIdentifier(JoinedFlatTable.colName(col, flatDesc.useAlias()), null) + " " + JoinedFlatTable.getHiveDataType(col.getDatatype()) + "\n");
        }
        ddl.append(")\n");
        if (TEXTFILE.equals(storageFormat)) {
            ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '" + fieldDelimiter + "'\n");
        }
        ddl.append("STORED AS " + storageFormat + "\n");
        ddl.append("LOCATION '" + JoinedFlatTable.getTableDir(flatDesc, storageDfsDir) + "';").append("\n");
        ddl.append("ALTER TABLE " + flatDesc.getTableName() + " SET TBLPROPERTIES('auto.purge'='true');\n");
        return ddl.toString();
    }

    public static String generateDropTableStatement(IJoinedFlatTableDesc flatDesc) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("DROP TABLE IF EXISTS " + flatDesc.getTableName() + ";").append("\n");
        return ddl.toString();
    }

    public static String generateInsertDataStatement(IJoinedFlatTableDesc flatDesc) {
        CubeSegment segment = (CubeSegment)flatDesc.getSegment();
        KylinConfig kylinConfig = null == segment ? KylinConfig.getInstanceFromEnv() : flatDesc.getSegment().getConfig();
        if (kylinConfig.isAdvancedFlatTableUsed()) {
            try {
                Class<?> advancedFlatTable = Class.forName(kylinConfig.getAdvancedFlatTableClass());
                Method method = advancedFlatTable.getMethod("generateInsertDataStatement", IJoinedFlatTableDesc.class, JobEngineConfig.class);
                return (String)method.invoke(null, flatDesc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "INSERT OVERWRITE TABLE " + FlatTableSqlQuoteUtils.quoteIdentifier(flatDesc.getTableName(), null) + " " + JoinedFlatTable.generateSelectDataStatement(flatDesc) + ";\n";
    }

    public static String generateSelectDataStatement(IJoinedFlatTableDesc flatDesc) {
        return JoinedFlatTable.generateSelectDataStatement(flatDesc, false, null, null);
    }

    public static String generateSelectDataStatement(IJoinedFlatTableDesc flatDesc, boolean singleLine, String[] skipAs, SqlDialect sqlDialect) {
        String sep = singleLine ? " " : "\n";
        List<Object> skipAsList = skipAs == null ? new ArrayList() : Arrays.asList(skipAs);
        StringBuilder sql2 = new StringBuilder();
        sql2.append("SELECT" + sep);
        for (int i = 0; i < flatDesc.getAllColumns().size(); ++i) {
            TblColRef col = flatDesc.getAllColumns().get(i);
            if (i > 0) {
                sql2.append(",");
            }
            String colTotalName = String.format(Locale.ROOT, "%s.%s", col.getTableRef().getTableName(), col.getName());
            String quotedColTotalName = String.format(Locale.ROOT, "%s.%s", FlatTableSqlQuoteUtils.quoteIdentifier(col.getTableAlias(), sqlDialect), FlatTableSqlQuoteUtils.quoteIdentifier(col.getName(), sqlDialect));
            if (skipAsList.contains(colTotalName)) {
                sql2.append(quotedColTotalName).append(sep);
                continue;
            }
            sql2.append(quotedColTotalName).append(" as ").append(FlatTableSqlQuoteUtils.quoteIdentifier(JoinedFlatTable.colName(col), sqlDialect)).append(sep);
        }
        JoinedFlatTable.appendJoinStatement(flatDesc, sql2, singleLine, sqlDialect);
        JoinedFlatTable.appendWhereStatement(flatDesc, sql2, singleLine, sqlDialect);
        return sql2.toString();
    }

    static void appendJoinStatement(IJoinedFlatTableDesc flatDesc, StringBuilder sql2, boolean singleLine, SqlDialect sqlDialect) {
        String sep = singleLine ? " " : "\n";
        HashSet<TableRef> dimTableCache = new HashSet<TableRef>();
        DataModelDesc model = flatDesc.getDataModel();
        TableRef rootTable = model.getRootFactTable();
        sql2.append(" FROM ").append(FlatTableSqlQuoteUtils.quoteTableIdentity(flatDesc.getDataModel().getRootFactTable(), sqlDialect)).append(" as ").append(FlatTableSqlQuoteUtils.quoteIdentifier(rootTable.getAlias(), sqlDialect)).append(sep);
        for (JoinTableDesc lookupDesc : model.getJoinTables()) {
            TblColRef[] fk;
            TableRef dimTable;
            JoinDesc join2 = lookupDesc.getJoin();
            if (join2 == null || join2.getType().equals("") || dimTableCache.contains(dimTable = lookupDesc.getTableRef())) continue;
            TblColRef[] pk = join2.getPrimaryKeyColumns();
            if (pk.length != (fk = join2.getForeignKeyColumns()).length) {
                throw new RuntimeException("Invalid join condition of lookup table:" + lookupDesc);
            }
            String joinType = join2.getType().toUpperCase(Locale.ROOT);
            sql2.append(joinType).append(" JOIN ").append(FlatTableSqlQuoteUtils.quoteTableIdentity(dimTable, sqlDialect)).append(" as ").append(FlatTableSqlQuoteUtils.quoteIdentifier(dimTable.getAlias(), sqlDialect)).append(sep);
            sql2.append("ON ");
            for (int i = 0; i < pk.length; ++i) {
                if (i > 0) {
                    sql2.append(" AND ");
                }
                sql2.append(JoinedFlatTable.getQuotedColExpressionInSourceDB(flatDesc, fk[i], sqlDialect)).append(" = ").append(JoinedFlatTable.getQuotedColExpressionInSourceDB(flatDesc, pk[i], sqlDialect));
            }
            sql2.append(sep);
            dimTableCache.add(dimTable);
        }
    }

    private static void appendDistributeStatement(StringBuilder sql2, List<TblColRef> redistCols) {
        sql2.append(" DISTRIBUTE BY ");
        for (TblColRef redistCol : redistCols) {
            sql2.append(JoinedFlatTable.colName(redistCol, true)).append(",");
        }
        sql2.deleteCharAt(sql2.length() - 1);
        sql2.append(";\n");
    }

    private static void appendClusterStatement(StringBuilder sql2, TblColRef clusterCol) {
        sql2.append(" CLUSTER BY CAST(").append(JoinedFlatTable.colName(clusterCol)).append(" AS STRING);\n");
    }

    private static void appendWhereStatement(IJoinedFlatTableDesc flatDesc, StringBuilder sql2, boolean singleLine, SqlDialect sqlDialect) {
        SegmentRange segRange;
        PartitionDesc partDesc;
        String sep = singleLine ? " " : "\n";
        StringBuilder whereBuilder = new StringBuilder();
        whereBuilder.append("WHERE 1=1");
        DataModelDesc model = flatDesc.getDataModel();
        if (StringUtils.isNotEmpty(model.getFilterCondition())) {
            String filterCondition = model.getFilterCondition();
            if (flatDesc.getSegment() != null) {
                JoinedFormatter formatter = new JoinedFormatter(flatDesc);
                filterCondition = formatter.formatSentence(model.getFilterCondition());
            }
            String quotedFilterCondition = FlatTableSqlQuoteUtils.quoteIdentifierInSqlExpr(flatDesc, filterCondition, null);
            whereBuilder.append(" AND (").append(quotedFilterCondition).append(") ");
        }
        if (flatDesc.getSegment() != null && (partDesc = model.getPartitionDesc()) != null && partDesc.getPartitionDateColumn() != null && (segRange = flatDesc.getSegRange()) != null && !segRange.isInfinite()) {
            whereBuilder.append(" AND (");
            String quotedPartitionCond = FlatTableSqlQuoteUtils.quoteIdentifierInSqlExpr(flatDesc, partDesc.getPartitionConditionBuilder().buildDateRangeCondition(partDesc, flatDesc.getSegment(), segRange, null), sqlDialect);
            whereBuilder.append(quotedPartitionCond);
            whereBuilder.append(")" + sep);
        }
        sql2.append(whereBuilder.toString());
    }

    public static String colName(TblColRef col) {
        return JoinedFlatTable.colName(col, true);
    }

    public static String colName(TblColRef col, boolean useAlias) {
        return useAlias ? col.getTableAlias() + "_" + col.getName() : col.getName();
    }

    private static String getHiveDataType(String javaDataType) {
        String originDataType = javaDataType.toLowerCase(Locale.ROOT);
        String hiveDataType = originDataType.startsWith("varchar") ? "string" : (originDataType.startsWith("integer") ? "int" : (originDataType.startsWith("bigint") ? "bigint" : (originDataType.startsWith("double") ? "double" : (originDataType.startsWith("float") ? "float" : originDataType))));
        return hiveDataType;
    }

    public static String generateRedistributeFlatTableStatement(IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        String tableName = flatDesc.getTableName();
        StringBuilder sql2 = new StringBuilder();
        sql2.append("INSERT OVERWRITE TABLE " + FlatTableSqlQuoteUtils.quoteIdentifier(tableName, null) + " SELECT * FROM " + FlatTableSqlQuoteUtils.quoteIdentifier(tableName, null));
        if (flatDesc.getClusterBy() != null) {
            JoinedFlatTable.appendClusterStatement(sql2, flatDesc.getClusterBy());
        } else if (flatDesc.getDistributedBy() != null) {
            JoinedFlatTable.appendDistributeStatement(sql2, Lists.newArrayList(flatDesc.getDistributedBy()));
        } else {
            int redistColumnCount = cubeDesc.getConfig().getHiveRedistributeColumnCount();
            RowKeyColDesc[] rowKeyColDescs = cubeDesc.getRowkey().getRowKeyColumns();
            if (rowKeyColDescs.length < redistColumnCount) {
                redistColumnCount = rowKeyColDescs.length;
            }
            ArrayList<TblColRef> redistColumns = Lists.newArrayListWithCapacity(redistColumnCount);
            for (int i = 0; i < redistColumnCount; ++i) {
                redistColumns.add(rowKeyColDescs[i].getColRef());
            }
            JoinedFlatTable.appendDistributeStatement(sql2, redistColumns);
        }
        return sql2.toString();
    }

    public static String getQuotedColExpressionInSourceDB(IJoinedFlatTableDesc flatDesc, TblColRef col, SqlDialect sqlDialect) {
        if (!col.getColumnDesc().isComputedColumn()) {
            return FlatTableSqlQuoteUtils.quoteIdentifier(col.getTableAlias(), sqlDialect) + "." + FlatTableSqlQuoteUtils.quoteIdentifier(col.getName(), sqlDialect);
        }
        String computeExpr = col.getColumnDesc().getComputedColumnExpr();
        return FlatTableSqlQuoteUtils.quoteIdentifierInSqlExpr(flatDesc, computeExpr, sqlDialect);
    }
}

