/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathManager {
    private static final Logger logger = LoggerFactory.getLogger(PathManager.class);

    public static String getParquetStoragePath(KylinConfig config, String cubeName, String segName, String identifier, String cuboidId) {
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        return PathManager.getParquetStoragePath(cube, segName, identifier, Long.parseLong(cuboidId));
    }

    public static String getParquetStoragePath(CubeInstance cube, String segName, String identifier, Long cuboidId) {
        String hdfsWorkDir = cube.getConfig().getHdfsWorkingDirectory(cube.getProject());
        return hdfsWorkDir + "parquet" + File.separator + cube.getName() + File.separator + segName + "_" + identifier + File.separator + cuboidId;
    }

    public static String getSegmentParquetStoragePath(CubeInstance cube, String segName, String identifier) {
        String hdfsWorkDir = cube.getConfig().getHdfsWorkingDirectory(cube.getProject());
        return hdfsWorkDir + "parquet" + File.separator + cube.getName() + File.separator + segName + "_" + identifier;
    }

    public static String getSegmentParquetStoragePath(String hdfsWorkDir, String cubeName, CubeSegment segment) {
        String segmentName = segment.getName();
        String identifier = segment.getStorageLocationIdentifier();
        return hdfsWorkDir + "parquet" + File.separator + cubeName + File.separator + segmentName + "_" + identifier;
    }

    public static boolean deleteSegmentParquetStoragePath(CubeInstance cube, CubeSegment segment) throws IOException {
        if (cube == null || segment == null) {
            return false;
        }
        String path = PathManager.getSegmentParquetStoragePath(cube, segment.getName(), segment.getStorageLocationIdentifier());
        logger.info("Deleting segment parquet path {}", (Object)path);
        HadoopUtil.deletePath(HadoopUtil.getCurrentConfiguration(), new Path(path));
        return true;
    }

    public static boolean deleteJobTempPath(KylinConfig kylinConfig, String project, String jobId) {
        if (StringUtils.isEmpty(jobId) || StringUtils.isEmpty(project)) {
            return false;
        }
        Path jobTmpPath = new Path(kylinConfig.getJobTmpDir(project));
        try {
            Path[] toDeletedPath = HadoopUtil.getFilteredPath(jobTmpPath.getFileSystem(HadoopUtil.getCurrentConfiguration()), jobTmpPath, jobId);
            if (toDeletedPath != null && toDeletedPath.length > 0) {
                for (Path deletedPath : toDeletedPath) {
                    logger.info("Deleting job tmp path {}", (Object)deletedPath.toString());
                    HadoopUtil.deletePath(HadoopUtil.getCurrentConfiguration(), deletedPath);
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not delete job tmp path: {}", (Object)jobTmpPath);
            return false;
        }
        return true;
    }
}

