/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.utils.UpdateMetadataUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.Segments;

public class NSparkUpdateMetaAndCleanupAfterMergeStep
extends NSparkExecutable {
    public NSparkUpdateMetaAndCleanupAfterMergeStep() {
        this.setName("Clean Up Old Segment for merging job");
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String cubeId = this.getParam("cubeId");
        String mergedSegmentUuid = this.getParam("segmentId");
        KylinConfig config = this.wrapConfig(context);
        CubeInstance cube = CubeManager.getInstance(config).getCubeByUuid(cubeId);
        try {
            UpdateMetadataUtil.updateMetadataAfterMerge(cubeId, mergedSegmentUuid, config);
        }
        catch (IOException e) {
            throw new ExecuteException("Can not update metadata of cube: " + cube.getName());
        }
        if (config.cleanStorageAfterDelOperation()) {
            CubeSegment mergedSegment = cube.getSegmentById(mergedSegmentUuid);
            Segments<CubeSegment> mergingSegments = cube.getMergingSegments(mergedSegment);
            for (CubeSegment segment : mergingSegments) {
                try {
                    PathManager.deleteSegmentParquetStoragePath(cube, segment);
                }
                catch (IOException e) {
                    throw new ExecuteException("Can not delete segment: " + segment.getName() + ", in cube: " + cube.getName());
                }
            }
        }
        return ExecuteResult.createSucceed();
    }

    @Override
    public void cleanup(ExecuteResult result) throws ExecuteException {
        if (result != null && result.state().ordinal() == ExecuteResult.State.SUCCEED.ordinal()) {
            PathManager.deleteJobTempPath(this.getConfig(), this.getParam("project"), this.getParam("jobId"));
        }
    }
}

