/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkExecutable.class);

    protected void setSparkSubmitClassName(String className) {
        this.setParam("className", className);
    }

    public String getSparkSubmitClassName() {
        return this.getParam("className");
    }

    public String getJars() {
        return this.getParam("jars");
    }

    protected void setDistMetaUrl(StorageURL storageURL) {
        HashMap<String, String> stringStringHashMap = Maps.newHashMap(storageURL.getAllParameters());
        StorageURL copy = storageURL.copy(stringStringHashMap);
        this.setParam("distMetaUrl", copy.toString());
    }

    public String getDistMetaUrl() {
        return this.getParam("distMetaUrl");
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubeInstance cube = cubeMgr.getCube(this.getCubeName());
        KylinConfig config = cube.getConfig();
        this.setLogPath(this.getSparkDriverLogHdfsPath(context.getConfig()));
        config = this.wrapConfig(config);
        String sparkHome = KylinConfig.getSparkHome();
        if (StringUtils.isEmpty(sparkHome) && !config.isUTEnv()) {
            throw new RuntimeException("Missing spark home");
        }
        String kylinJobJar = config.getKylinParquetJobJarPath();
        if (!config.isUTEnv() && StringUtils.isEmpty(kylinJobJar) && !config.isUTEnv()) {
            throw new RuntimeException("Missing kylin parquet job jar");
        }
        String hadoopConf = System.getProperty("kylin.hadoop.conf.dir");
        logger.info("write hadoop conf is {} ", (Object)config.getBuildConf());
        if (!config.getBuildConf().isEmpty()) {
            logger.info("write hadoop conf is {} ", (Object)config.getBuildConf());
            hadoopConf = config.getBuildConf();
        }
        if (StringUtils.isEmpty(hadoopConf) && !config.isUTEnv() && !config.isZKLocal()) {
            throw new RuntimeException("kylin_hadoop_conf_dir is empty, check if there's error in the output of 'kylin.sh start'");
        }
        File hiveConfFile = new File(hadoopConf, "hive-site.xml");
        if (!(hiveConfFile.exists() || config.isUTEnv() || config.isZKLocal())) {
            throw new RuntimeException("Cannot find hive-site.xml in kylin_hadoop_conf_dir: " + hadoopConf + ". In order to enable spark cubing, you must set kylin.env.hadoop-conf-dir to a dir which contains at least core-site.xml, hdfs-site.xml, hive-site.xml, mapred-site.xml, yarn-site.xml");
        }
        String jars = this.getJars();
        if (StringUtils.isEmpty(jars)) {
            jars = kylinJobJar;
        }
        this.deleteJobTmpDirectoryOnExists();
        this.onExecuteStart(context);
        try {
            this.attachMetadataAndKylinProps(config);
        }
        catch (IOException e) {
            throw new ExecuteException("meta dump failed", e);
        }
        String filePath = this.dumpArgs();
        if (config.isUTEnv() || config.isLocalEnv() || config.isZKLocal()) {
            return this.runLocalMode(filePath, config);
        }
        logger.info("Task id: {}", (Object)this.getId());
        this.killOrphanApplicationIfExists(config, this.getId());
        return this.runSparkSubmit(config, hadoopConf, jars, kylinJobJar, "-className " + this.getSparkSubmitClassName() + " " + filePath, this.getParent().getId());
    }

    void attachMetadataAndKylinProps(KylinConfig config) throws IOException {
        Set<String> dumpList = this.getMetadataDumpList(config);
        MetaDumpUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, config, this.getDistMetaUrl());
    }

    String dumpArgs() throws ExecuteException {
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile("segmentIds", "");
            FileUtils.writeByteArrayToFile(tmpDir, JsonUtil.writeValueAsBytes(this.getParams()));
            logger.info("Spark job args json is : {}.", (Object)JsonUtil.writeValueAsString(this.getParams()));
            return tmpDir.getCanonicalPath();
        }
        catch (IOException e) {
            if (tmpDir != null && tmpDir.exists()) {
                try {
                    Files.delete(tmpDir.toPath());
                }
                catch (IOException e1) {
                    throw new ExecuteException("Write cuboidLayoutIds failed: Error for delete file " + tmpDir.getPath(), e1);
                }
            }
            throw new ExecuteException("Write cuboidLayoutIds failed: ", e);
        }
    }

    public String getSparkDriverLogHdfsPath(KylinConfig config) {
        return String.format(Locale.ROOT, "%s.%s.log", config.getJobOutputStorePath(this.getParam("project"), this.getId()), System.currentTimeMillis());
    }

    protected KylinConfig wrapConfig(ExecutableContext context) {
        return this.wrapConfig(context.getConfig());
    }

    protected KylinConfig wrapConfig(KylinConfig originalConfig) {
        String project = this.getParam("project");
        Preconditions.checkState(StringUtils.isNotBlank(project), "job " + this.getId() + " project info is empty");
        HashMap<String, String> jobOverrides = new HashMap<String, String>();
        String parentId = this.getParentId();
        jobOverrides.put("job.id", StringUtils.defaultIfBlank(parentId, this.getId()));
        jobOverrides.put("job.project", project);
        if (StringUtils.isNotBlank(parentId)) {
            jobOverrides.put("job.stepId", this.getId());
        }
        jobOverrides.put("user.timezone", KylinConfig.getInstanceFromEnv().getTimeZone());
        jobOverrides.put("hdfs.working.dir", KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
        jobOverrides.put("spark.driver.log4j.appender.hdfs.File", Objects.isNull(this.getLogPath()) ? "null" : this.getLogPath());
        return KylinConfigExt.createInstance(originalConfig, jobOverrides);
    }

    private void killOrphanApplicationIfExists(KylinConfig config, String jobId) {
        PatternedLogger patternedLogger = new PatternedLogger(logger);
        String orphanApplicationId = null;
        try (YarnClient yarnClient = YarnClient.createYarnClient();){
            YarnConfiguration yarnConfiguration = new YarnConfiguration();
            yarnConfiguration.set("yarn.timeline-service.enabled", "false");
            yarnClient.init((Configuration)yarnConfiguration);
            yarnClient.start();
            HashSet<String> types = Sets.newHashSet("SPARK");
            EnumSet<YarnApplicationState> states = EnumSet.of(YarnApplicationState.NEW, YarnApplicationState.NEW_SAVING, YarnApplicationState.SUBMITTED, YarnApplicationState.ACCEPTED, YarnApplicationState.RUNNING);
            List applicationReports = yarnClient.getApplications(types, states);
            if (CollectionUtils.isEmpty((Collection)applicationReports)) {
                return;
            }
            for (ApplicationReport report : applicationReports) {
                if (!report.getName().equalsIgnoreCase("job_step_" + this.getId())) continue;
                orphanApplicationId = report.getApplicationId().toString();
                String killApplicationCmd = "yarn application -kill " + orphanApplicationId;
                config.getCliCommandExecutor().execute(killApplicationCmd, patternedLogger, jobId);
            }
        }
        catch (IOException | YarnException ex2) {
            logger.error("get yarn application failed");
        }
    }

    private ExecuteResult runSparkSubmit(KylinConfig config, String hadoopConf, String jars, String kylinJobJar, String appArgs, String jobId) {
        PatternedLogger patternedLogger = config.isJobLogPrintEnabled() ? new PatternedLogger(logger) : new PatternedLogger(null);
        try {
            String cmd = this.generateSparkCmd(config, hadoopConf, jars, kylinJobJar, appArgs);
            CliCommandExecutor exec = new CliCommandExecutor();
            exec.execute(cmd, patternedLogger, jobId);
            this.updateMetaAfterOperation(config);
            this.getManager().addJobInfo(this.getId(), this.getJobMetricsInfo(config));
            Map<String, String> extraInfo = this.makeExtraInfo(patternedLogger.getInfo());
            ExecuteResult ret = ExecuteResult.createSucceed(patternedLogger.getBufferedLog());
            ret.getExtraInfo().putAll(extraInfo);
            return ret;
        }
        catch (Exception e) {
            return ExecuteResult.createError(e);
        }
    }

    protected void updateMetaAfterOperation(KylinConfig config) throws IOException {
    }

    protected Map<String, String> getJobMetricsInfo(KylinConfig config) {
        return Maps.newHashMap();
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map<String, String> sparkConfigOverride = config.getSparkConfigOverride();
        if (!sparkConfigOverride.containsKey("spark.driver.memory")) {
            sparkConfigOverride.put("spark.driver.memory", this.computeStepDriverMemory() + "m");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            sparkConfigOverride.put("spark.hadoop.hive.metastore.sasl.enabled", "true");
        }
        this.replaceSparkNodeJavaOpsConfIfNeeded(config, sparkConfigOverride);
        return sparkConfigOverride;
    }

    private void replaceSparkNodeJavaOpsConfIfNeeded(KylinConfig config, Map<String, String> sparkConfigOverride) {
        Map<String, String> extendedOverrides;
        String sparkDriverExtraJavaOptionsKey = "spark.driver.extraJavaOptions";
        StringBuilder sb = new StringBuilder();
        if (sparkConfigOverride.containsKey(sparkDriverExtraJavaOptionsKey)) {
            sb.append(sparkConfigOverride.get(sparkDriverExtraJavaOptionsKey));
        }
        String serverIp = "127.0.0.1";
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("use the InetAddress get local ip failed!", e);
        }
        String serverPort = config.getServerPort();
        String hdfsWorkingDir = config.getHdfsWorkingDirectory();
        String sparkDriverHdfsLogPath = null;
        if (config instanceof KylinConfigExt && Objects.nonNull(extendedOverrides = ((KylinConfigExt)config).getExtendedOverrides())) {
            sparkDriverHdfsLogPath = extendedOverrides.get("spark.driver.log4j.appender.hdfs.File");
        }
        String log4jConfiguration = "file:" + config.getLogSparkDriverPropertiesFile();
        sb.append(String.format(Locale.ROOT, " -Dlog4j.configuration=%s ", log4jConfiguration));
        sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.enabled=%s ", config.isKerberosEnabled()));
        if (config.isKerberosEnabled().booleanValue()) {
            sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.principal=%s ", config.getKerberosPrincipal()));
            sb.append(String.format(Locale.ROOT, " -Dkylin.kerberos.keytab=%s", config.getKerberosKeytabPath()));
            if (config.getPlatformZKEnable().booleanValue()) {
                sb.append(String.format(Locale.ROOT, " -Djava.security.auth.login.config=%s", config.getKerberosJaasConfPath()));
                sb.append(String.format(Locale.ROOT, " -Djava.security.krb5.conf=%s", config.getKerberosKrb5ConfPath()));
            }
        }
        sb.append(String.format(Locale.ROOT, " -Dkylin.hdfs.working.dir=%s ", hdfsWorkingDir));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.log4j.appender.hdfs.File=%s ", sparkDriverHdfsLogPath));
        sb.append(String.format(Locale.ROOT, " -Dlog4j.debug=%s ", "true"));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.rest.server.ip=%s ", serverIp));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.rest.server.port=%s ", serverPort));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.param.taskId=%s ", this.getId()));
        sb.append(String.format(Locale.ROOT, " -Dspark.driver.local.logDir=%s ", config.getKylinLogDir() + "/spark"));
        sparkConfigOverride.put(sparkDriverExtraJavaOptionsKey, sb.toString());
    }

    protected String generateSparkCmd(KylinConfig config, String hadoopConf, String jars, String kylinJobJar, String appArgs) {
        String sparkUploadFiles;
        StringBuilder sb = new StringBuilder();
        String sparkSubmitCmd = config.getSparkSubmitCmd() != null ? config.getSparkSubmitCmd() : KylinConfig.getSparkHome() + "/bin/spark-submit";
        sb.append("export HADOOP_CONF_DIR=%s && %s --class org.apache.kylin.engine.spark.application.SparkEntry ");
        Map<String, String> sparkConfs = this.getSparkConfigOverride(config);
        for (Map.Entry<String, String> entry : sparkConfs.entrySet()) {
            this.appendSparkConf(sb, entry.getKey(), entry.getValue());
        }
        if (!this.isLocalMaster(sparkConfs)) {
            this.appendSparkConf(sb, "spark.executor.extraClassPath", Paths.get(kylinJobJar, new String[0]).getFileName().toString());
        }
        this.appendSparkConf(sb, "spark.driver.extraClassPath", kylinJobJar);
        if (sparkConfs.containsKey("spark.sql.hive.metastore.jars")) {
            jars = jars + "," + sparkConfs.get("spark.sql.hive.metastore.jars");
        }
        if (StringUtils.isNotBlank(sparkUploadFiles = config.sparkUploadFiles(this.isLocalMaster(sparkConfs)))) {
            sb.append("--files ").append(sparkUploadFiles).append(" ");
        }
        sb.append("--name job_step_%s ");
        sb.append("--jars %s %s %s");
        String cmd = String.format(Locale.ROOT, sb.toString(), hadoopConf, sparkSubmitCmd, this.getId(), jars, kylinJobJar, appArgs);
        logger.info("spark submit cmd: {}", (Object)cmd);
        return cmd;
    }

    protected void appendSparkConf(StringBuilder sb, String key, String value) {
        sb.append(" --conf '").append(key).append("=").append(value.trim()).append("' ");
    }

    private ExecuteResult runLocalMode(String appArgs, KylinConfig config) {
        try {
            Class<Object> appClz = ClassUtil.forName(this.getSparkSubmitClassName(), Object.class);
            appClz.getMethod("main", String[].class).invoke(null, new Object[]{new String[]{appArgs}});
            this.updateMetaAfterOperation(config);
            this.getManager().addJobInfo(this.getId(), this.getJobMetricsInfo(config));
            return ExecuteResult.createSucceed();
        }
        catch (Exception e) {
            return ExecuteResult.createError(e);
        }
    }

    protected Set<String> getMetadataDumpList(KylinConfig config) {
        return Collections.emptySet();
    }

    private void deleteJobTmpDirectoryOnExists() {
        StorageURL storageURL = StorageURL.valueOf(this.getDistMetaUrl());
        String metaPath = storageURL.getParameter("path");
        String[] directories = metaPath.split("/");
        String lastDirectory = directories[directories.length - 1];
        String taskPath = metaPath.substring(0, metaPath.length() - 1 - lastDirectory.length());
        try {
            Path path = new Path(taskPath);
            HadoopUtil.deletePath(HadoopUtil.getCurrentConfiguration(), path);
        }
        catch (Exception e) {
            logger.error("delete job tmp in path {} failed.", (Object)taskPath, (Object)e);
        }
    }

    protected boolean isLocalMaster(Map<String, String> sparkConfs) {
        String master = sparkConfs.getOrDefault("spark.master", "yarn");
        return master.equalsIgnoreCase("local") || master.toLowerCase(Locale.ROOT).startsWith("local[");
    }

    public boolean needMergeMetadata() {
        return false;
    }
}

