/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.spark.job.JobStepFactory;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.base.Preconditions;

public class NSparkCubingJob
extends CubingJob {
    public static final String SOURCE_RECORD_COUNT = "sourceRecordCount";
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingJob.class);
    private static final String DEPLOY_ENV_NAME = "envName";
    private CubeInstance cube;

    public static NSparkCubingJob create(Set<CubeSegment> segments, String submitter) {
        return NSparkCubingJob.create(segments, submitter, CubingJob.CubingJobTypeEnum.BUILD, UUID.randomUUID().toString());
    }

    public static NSparkCubingJob create(Set<CubeSegment> segments, String submitter, CubingJob.CubingJobTypeEnum jobType, String jobId) {
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((submitter != null ? 1 : 0) != 0);
        NSparkCubingJob job = new NSparkCubingJob();
        job.cube = segments.iterator().next().getCubeInstance();
        SimpleDateFormat format = new SimpleDateFormat("z yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        format.setTimeZone(TimeZone.getTimeZone(job.cube.getConfig().getTimeZone()));
        long startTime = 0x7FFFFFFFFFFFFFFEL;
        long endTime = 0L;
        StringBuilder builder = new StringBuilder();
        builder.append((Object)jobType).append(" CUBE - ");
        for (CubeSegment segment : segments) {
            startTime = startTime < (Long)segment.getSegRange().start.v ? startTime : (Long)segment.getSegRange().start.v;
            endTime = endTime > (Long)segment.getSegRange().end.v ? endTime : (Long)segment.getSegRange().end.v;
            builder.append(segment.getCubeInstance().getDisplayName()).append(" - ").append(segment.getName()).append(" - ");
        }
        builder.append(format.format(new Date(System.currentTimeMillis())));
        job.setId(jobId);
        job.setName(builder.toString());
        job.setProjectName(job.cube.getProject());
        job.setTargetSubject(job.cube.getModel().getId());
        job.setTargetSegments(segments.stream().map(x -> String.valueOf(x.getUuid())).collect(Collectors.toList()));
        job.setProject(job.cube.getProject());
        job.setSubmitter(submitter);
        job.setParam("segmentId", segments.stream().map(x -> String.valueOf(x.getUuid())).collect(Collectors.joining(" ")));
        job.setParam("jobId", jobId);
        job.setParam("segmentName", segments.iterator().next().getName());
        job.setParam("project", job.cube.getProject());
        job.setParam("cubeName", job.cube.getName());
        job.setParam("targetModel", job.getTargetSubject());
        job.setParam("cubeId", job.cube.getId());
        job.setParam("segmentIds", String.join((CharSequence)",", job.getTargetSegments()));
        job.setParam("dataRangeStart", String.valueOf(startTime));
        job.setParam("dataRangeEnd", String.valueOf(endTime));
        job.setParam("outputMetaUrl", job.cube.getConfig().getMetadataUrl().toString());
        job.setParam("cuboidsNum", String.valueOf(job.cube.getDescriptor().getAllCuboids().size()));
        job.setParam("jobType", jobType.toString());
        JobStepFactory.addStep(job, JobStepType.RESOURCE_DETECT, job.cube);
        JobStepFactory.addStep(job, JobStepType.CUBING, job.cube);
        return job;
    }

    @Override
    public Set<String> getMetadataDumpList(KylinConfig config) {
        String cubeId = this.getParam("cubeId");
        CubeInstance cubeInstance = CubeManager.getInstance(config).getCubeByUuid(cubeId);
        return MetaDumpUtil.collectCubeMetadata(cubeInstance);
    }

    @Override
    public String getDeployEnvName() {
        return this.getParam(DEPLOY_ENV_NAME);
    }

    @Override
    public long findSourceRecordCount() {
        return Long.parseLong(this.findExtraInfo(SOURCE_RECORD_COUNT, "0"));
    }

    @Override
    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong(MAP_REDUCE_WAIT_TIME, 0L);
    }

    public NSparkCubingStep getSparkCubingStep() {
        return this.getTask(NSparkCubingStep.class);
    }

    NResourceDetectStep getResourceDetectStep() {
        return this.getTask(NResourceDetectStep.class);
    }

    public CubeInstance getCube() {
        return this.cube;
    }

    public void setCube(CubeInstance cube) {
        this.cube = cube;
    }

    public void cleanupAfterJobDiscard() {
        try {
            PathManager.deleteJobTempPath(this.getConfig(), this.getParam("project"), this.getParam("jobId"));
            CubeManager cubeManager = CubeManager.getInstance(this.getConfig());
            CubeInstance cube = cubeManager.getCube(this.getParam("cubeName"));
            CubeSegment segment = cube.getSegment(this.getParam("segmentName"), SegmentStatusEnum.NEW);
            PathManager.deleteSegmentParquetStoragePath(cube, segment);
        }
        catch (IOException e) {
            logger.warn("Delete resource file failed after job be discarded, due to", e);
        }
    }
}

