/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.engine.spark.job.AggInfo;
import org.apache.kylin.engine.spark.job.AggInfo$;
import org.apache.kylin.engine.spark.job.CuboidStatisticsJob$;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mv!B\u0001\u0003\u0011\u0003y\u0011aE\"vE>LGm\u0015;bi&\u001cH/[2t\u0015>\u0014'BA\u0002\u0005\u0003\rQwN\u0019\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0015tw-\u001b8f\u0015\tI!\"A\u0003ls2LgN\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0014\u0007V\u0014w.\u001b3Ti\u0006$\u0018n\u001d;jGNTuNY\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=AQ!I\t\u0005\u0002\t\n!b\u001d;bi&\u001cH/[2t)\r\u0019sf\u000f\t\u0004+\u00112\u0013BA\u0013\u0017\u0005\u0015\t%O]1z!\u0011)r%\u000b\u0017\n\u0005!2\"A\u0002+va2,'\u0007\u0005\u0002\u0016U%\u00111F\u0006\u0002\u0005\u0019>tw\r\u0005\u0002\u0011[%\u0011aF\u0001\u0002\b\u0003\u001e<\u0017J\u001c4p\u0011\u0015\u0001\u0004\u00051\u00012\u0003\u001dIg\u000e];u\tN\u00042A\r\u001c9\u001b\u0005\u0019$B\u0001\u001b6\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b)I!aN\u001a\u0003\u000f\u0011\u000bG/Y:fiB\u0011!'O\u0005\u0003uM\u00121AU8x\u0011\u0015a\u0004\u00051\u0001>\u0003\r\u0019Xm\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0003\u0005~\u00121bU3h[\u0016tG/\u00138g_\"9A)EA\u0001\n\u0013)\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019y%M[3di\u001a!!C\u0001\u0001P'\rqEC\u0007\u0005\t#:\u0013\t\u0011)A\u0005%\u0006\u0019\u0011\u000eZ:\u0011\u0007U!\u0013\u0006\u0003\u0005U\u001d\n\u0005\t\u0015!\u0003V\u0003\r\u00118n\u0019\t\u0003+YK!a\u0016\f\u0003\u0007%sG\u000fC\u0003\u001f\u001d\u0012\u0005\u0011\fF\u0002[7r\u0003\"\u0001\u0005(\t\u000bEC\u0006\u0019\u0001*\t\u000bQC\u0006\u0019A+\t\u000fys%\u0019!C\u0005?\u0006!\u0011N\u001c4p+\u0005\u0001\u0007cA1gY5\t!M\u0003\u0002dI\u00069Q.\u001e;bE2,'BA3\u0017\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003O\n\u0014q\u0001T8oO6\u000b\u0007\u000f\u0003\u0004j\u001d\u0002\u0006I\u0001Y\u0001\u0006S:4w\u000e\t\u0005\bW:\u0003\r\u0011\"\u0003m\u0003A\tG\u000e\\\"vE>LGm\u001d\"jiN+G/F\u0001n!\r)BE\u001c\t\u0004+\u0011z\u0007CA$q\u0013\t\t\bJA\u0004J]R,w-\u001a:\t\u000fMt\u0005\u0019!C\u0005i\u0006!\u0012\r\u001c7Dk\n|\u0017\u000eZ:CSR\u001cV\r^0%KF$\"!\u001e=\u0011\u0005U1\u0018BA<\u0017\u0005\u0011)f.\u001b;\t\u000fe\u0014\u0018\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\t\rmt\u0005\u0015)\u0003n\u0003E\tG\u000e\\\"vE>LGm\u001d\"jiN+G\u000f\t\u0005\b{:\u0013\r\u0011\"\u0003\u007f\u0003\tAg-F\u0001\u0000!\u0011\t\t!a\u0006\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001[1tQ*!\u0011\u0011BA\u0006\u0003\u0019\u0019w.\\7p]*!\u0011QBA\b\u0003\u00199wn\\4mK*!\u0011\u0011CA\n\u0003\r\u0019w.\u001c\u0006\u0004\u0003+A\u0011AB:iC\u0012,G-\u0003\u0003\u0002\u001a\u0005\r!\u0001\u0004%bg\"4UO\\2uS>t\u0007bBA\u000f\u001d\u0002\u0006Ia`\u0001\u0004Q\u001a\u0004\u0003\"CA\u0011\u001d\n\u0007I\u0011BA\u0012\u0003A\u0011xn\u001e%bg\"\u001cu\u000eZ3t\u0019>tw-F\u0001S\u0011\u001d\t9C\u0014Q\u0001\nI\u000b\u0011C]8x\u0011\u0006\u001c\bnQ8eKNduN\\4!\u0011%\tYC\u0014a\u0001\n\u0013\ti#A\u0002jIb,\u0012!\u0016\u0005\n\u0003cq\u0005\u0019!C\u0005\u0003g\tq!\u001b3y?\u0012*\u0017\u000fF\u0002v\u0003kA\u0001\"_A\u0018\u0003\u0003\u0005\r!\u0016\u0005\b\u0003sq\u0005\u0015)\u0003V\u0003\u0011IG\r\u001f\u0011\t\u0013\u0005ub\n1A\u0005\n\u0005}\u0012AB7fi\u0016\u0014('F\u0001*\u0011%\t\u0019E\u0014a\u0001\n\u0013\t)%\u0001\u0006nKR,'OM0%KF$2!^A$\u0011!I\u0018\u0011IA\u0001\u0002\u0004I\u0003bBA&\u001d\u0002\u0006K!K\u0001\b[\u0016$XM\u001d\u001a!\u0011%\tyE\u0014a\u0001\n\u0013\ty$\u0001\u0006ti\u0006\u0014H/T5mYND\u0011\"a\u0015O\u0001\u0004%I!!\u0016\u0002\u001dM$\u0018M\u001d;NS2d7o\u0018\u0013fcR\u0019Q/a\u0016\t\u0011e\f\t&!AA\u0002%Bq!a\u0017OA\u0003&\u0011&A\u0006ti\u0006\u0014H/T5mYN\u0004\u0003\"CA0\u001d\u0002\u0007I\u0011BA \u0003!)g\u000eZ'jY2\u001c\b\"CA2\u001d\u0002\u0007I\u0011BA3\u00031)g\u000eZ'jY2\u001cx\fJ3r)\r)\u0018q\r\u0005\ts\u0006\u0005\u0014\u0011!a\u0001S!9\u00111\u000e(!B\u0013I\u0013!C3oI6KG\u000e\\:!\u0011\u001d\tyG\u0014C\u0001\u0003c\n\u0011d\u001d;bi&\u001cH/[2t/&$\b.\u001b8QCJ$\u0018\u000e^5p]R!\u00111OAF!\u0015\t)(!\"-\u001d\u0011\t9(!!\u000f\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \u000f\u0003\u0019a$o\\8u}%\tq#C\u0002\u0002\u0004Z\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0006%%\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\re\u0003\u0003\u0005\u0002\u000e\u00065\u0004\u0019AAH\u0003\u0011\u0011xn^:\u0011\u000b\u0005U\u0014Q\u0011\u001d\t\u000f\u0005Me\n\"\u0001\u0002\u0016\u0006!\u0011N\\5u)\u0005)\bbBAM\u001d\u0012\u0005\u00111T\u0001\u0007kB$\u0017\r^3\u0015\u0007U\fi\nC\u0004\u0002 \u0006]\u0005\u0019\u0001\u001d\u0002\u0003IDq!a)O\t\u0003\t)+\u0001\u0007va\u0012\fG/Z\"vE>LG\rF\u0002v\u0003OCq!a(\u0002\"\u0002\u0007\u0001\bC\u0004\u0002,:#\t!!,\u0002\u001f\u001d,GoQ;c_&$')\u001b;TKR$R!\\AX\u0003gCq!!-\u0002*\u0002\u0007!+A\u0005dk\n|\u0017\u000eZ%eg\"9\u0011QWAU\u0001\u0004)\u0016a\u00028S_^\\U-\u001f\u0005\b\u0003ssE\u0011AAK\u0003%\u0001(/\u001b8u'R\fG\u000f")
public class CuboidStatisticsJob
implements Serializable {
    private final long[] ids;
    private final int rkc;
    private final LongMap<AggInfo> org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info;
    private Integer[][] allCuboidsBitSet;
    private final HashFunction hf;
    private final long[] rowHashCodesLong;
    private int idx;
    private long meter2;
    private long startMills;
    private long endMills;

    public static Tuple2<Object, AggInfo>[] statistics(Dataset<Row> dataset, SegmentInfo segmentInfo) {
        return CuboidStatisticsJob$.MODULE$.statistics(dataset, segmentInfo);
    }

    public LongMap<AggInfo> org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info() {
        return this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info;
    }

    private Integer[][] allCuboidsBitSet() {
        return this.allCuboidsBitSet;
    }

    private void allCuboidsBitSet_$eq(Integer[][] x$1) {
        this.allCuboidsBitSet = x$1;
    }

    private HashFunction hf() {
        return this.hf;
    }

    private long[] rowHashCodesLong() {
        return this.rowHashCodesLong;
    }

    private int idx() {
        return this.idx;
    }

    private void idx_$eq(int x$1) {
        this.idx = x$1;
    }

    private long meter2() {
        return this.meter2;
    }

    private void meter2_$eq(long x$1) {
        this.meter2 = x$1;
    }

    private long startMills() {
        return this.startMills;
    }

    private void startMills_$eq(long x$1) {
        this.startMills = x$1;
    }

    private long endMills() {
        return this.endMills;
    }

    private void endMills_$eq(long x$1) {
        this.endMills = x$1;
    }

    public Iterator<AggInfo> statisticsWithinPartition(Iterator<Row> rows) {
        this.init();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-statisticsWithinPartition1-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        rows.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CuboidStatisticsJob $outer;

            public final void apply(Row r) {
                this.$outer.update(r);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.printStat();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-statisticsWithinPartition2-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        return this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().valuesIterator();
    }

    public void init() {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-Init1-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
        this.allCuboidsBitSet_$eq(this.getCuboidBitSet(this.ids, this.rkc));
        Predef$.MODULE$.longArrayOps(this.ids).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CuboidStatisticsJob $outer;

            public final Option<AggInfo> apply(long i) {
                return this.$outer.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().put(i, (Object)new AggInfo(i, AggInfo$.MODULE$.apply$default$2(), AggInfo$.MODULE$.apply$default$3(), AggInfo$.MODULE$.apply$default$4()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CuboidStatisticsJob-Init2-").append((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString());
    }

    public void update(Row r) {
        this.idx_$eq(this.idx() + 1);
        if (this.idx() <= 5) {
            Predef$.MODULE$.println((Object)r);
        }
        this.updateCuboid(r);
    }

    public void updateCuboid(Row r) {
        int idx;
        for (idx = 0; idx < this.rkc; ++idx) {
            Hasher hc = this.hf().newHasher();
            String colValue = r.get(idx) == null ? "0" : r.get(idx).toString();
            this.rowHashCodesLong()[idx] = hc.putUnencodedChars(colValue).hash().padToLong() + (long)idx;
        }
        this.startMills_$eq(System.currentTimeMillis());
        int n = this.allCuboidsBitSet().length;
        for (idx = 0; idx < n; ++idx) {
            long value = 0L;
            Integer[] currCuboidBitSet = this.allCuboidsBitSet()[idx];
            int currCuboidLength = currCuboidBitSet.length;
            for (int position = 0; position < currCuboidLength; ++position) {
                value += this.rowHashCodesLong()[Predef$.MODULE$.Integer2int(currCuboidBitSet[position])];
            }
            ((AggInfo)this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info().apply(this.ids[idx])).cuboid().counter().addHashDirectly(value);
        }
        this.endMills_$eq(System.currentTimeMillis());
        this.meter2_$eq(this.meter2() + (this.endMills() - this.startMills()));
    }

    /*
     * WARNING - void declaration
     */
    public Integer[][] getCuboidBitSet(long[] cuboidIds, int nRowKey) {
        void var3_3;
        Integer[][] allCuboidsBitSet = new Integer[cuboidIds.length][];
        for (int j = 0; j < cuboidIds.length; ++j) {
            long cuboidId = cuboidIds[j];
            allCuboidsBitSet[j] = new Integer[Long.bitCount(cuboidId)];
            long mask = 1L << nRowKey - 1;
            int position = 0;
            for (int i = 0; i < nRowKey; ++i) {
                if ((mask & cuboidId) > 0L) {
                    allCuboidsBitSet[j][position] = Predef$.MODULE$.int2Integer(i);
                    ++position;
                }
                mask >>= 1;
            }
        }
        return var3_3;
    }

    public void printStat() {
        Predef$.MODULE$.println((Object)"    Stats");
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"i      :").append((Object)BoxesRunTime.boxToInteger((int)this.idx())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"meter  :").append((Object)BoxesRunTime.boxToLong((long)this.meter2())).toString());
    }

    public CuboidStatisticsJob(long[] ids, int rkc) {
        this.ids = ids;
        this.rkc = rkc;
        this.org$apache$kylin$engine$spark$job$CuboidStatisticsJob$$info = LongMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.allCuboidsBitSet = (Integer[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.class)));
        this.hf = Hashing.murmur3_128();
        this.rowHashCodesLong = new long[rkc];
        this.idx = 0;
        this.meter2 = 0L;
        this.startMills = 0L;
        this.endMills = 0L;
    }
}

