/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.engine.spark.builder.CubeBuilderHelper$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.UdfManager$;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.DTType;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.LiteralColumnDesc;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct$;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct$;
import org.apache.spark.sql.udaf.EncodeTopN;
import org.apache.spark.sql.udaf.EncodeTopN$;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct$;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct$;
import org.apache.spark.sql.udaf.ReuseTopN;
import org.apache.spark.sql.udaf.ReuseTopN$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class CuboidAggregator$ {
    public static final CuboidAggregator$ MODULE$;

    static {
        new CuboidAggregator$();
    }

    public Dataset<Row> agg(SparkSession ss, Dataset<Row> dataSet, Set<Integer> dimensions, Map<Integer, FunctionDesc> measures, SpanningTree spanningTree, boolean isSparkSql) {
        return this.aggInternal(ss, dataSet, dimensions, measures, isSparkSql);
    }

    public Dataset<Row> aggInternal(SparkSession ss, Dataset<Row> dataSet, Set<Integer> dimensions, Map<Integer, FunctionDesc> measures, boolean isSparkSql) {
        Dataset dataset;
        Dataset df;
        if (measures.isEmpty()) {
            return dataSet.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns(dimensions))).dropDuplicates();
        }
        boolean reuseLayout = Predef$.MODULE$.refArrayOps((Object[])dataSet.schema().fieldNames()).contains((Object)((Integer)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(measures.keySet()).asScala()).head()).toString());
        Seq agg2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1)new Serializable(dataSet, isSparkSql, reuseLayout){
            public static final long serialVersionUID = 0L;
            private final Dataset dataSet$1;
            private final boolean isSparkSql$1;
            private final boolean reuseLayout$1;

            public final Column apply(Tuple2<Integer, FunctionDesc> x0$1) {
                Tuple2<Integer, FunctionDesc> tuple2 = x0$1;
                if (tuple2 != null) {
                    Column column;
                    Integer id = (Integer)tuple2._1();
                    FunctionDesc measure = (FunctionDesc)tuple2._2();
                    ListBuffer columns = new ListBuffer();
                    if (this.reuseLayout$1) {
                        columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(id.toString())}));
                    } else if (((ColumnDesc)measure.pra().head()).isColumnType()) {
                        scala.collection.immutable.Map colIndex = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.dataSet$1.schema().fieldNames()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, String> apply(Tuple2<String, Object> tp) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp._2$mcI$sp()), tp._1());
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                        columns.appendAll((TraversableOnce)measure.pra().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Column apply(ColumnDesc p) {
                                return functions$.MODULE$.col(((Object)BoxesRunTime.boxToInteger((int)p.id())).toString());
                            }
                        }, List$.MODULE$.canBuildFrom()));
                    } else {
                        Object value = ((LiteralColumnDesc)measure.pra().head()).value();
                        columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column((Expression)Literal$.MODULE$.create(value, ((ColumnDesc)measure.pra().head()).dataType()))}));
                    }
                    String string = measure.expression().toUpperCase(Locale.ROOT);
                    if ("MAX".equals(string)) {
                        column = functions$.MODULE$.max((Column)columns.head()).as(id.toString());
                    } else if ("MIN".equals(string)) {
                        column = functions$.MODULE$.min((Column)columns.head()).as(id.toString());
                    } else if ("SUM".equals(string)) {
                        column = functions$.MODULE$.sum((Column)columns.head()).as(id.toString());
                    } else if ("COUNT".equals(string)) {
                        column = this.reuseLayout$1 ? functions$.MODULE$.sum((Column)columns.head()).as(id.toString()) : functions$.MODULE$.count((Column)columns.head()).as(id.toString());
                    } else if ("COUNT_DISTINCT".equals(string)) {
                        Column column2;
                        if (this.isSparkSql$1) {
                            column2 = functions$.MODULE$.countDistinct((Column)columns.head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).as(id.toString());
                        } else {
                            AggregateFunction cdAggregate = CuboidAggregator$.MODULE$.org$apache$kylin$engine$spark$job$CuboidAggregator$$getCountDistinctAggregate((ListBuffer<Column>)columns, measure.returnType(), this.reuseLayout$1);
                            column2 = new Column((Expression)cdAggregate.toAggregateExpression()).as(id.toString());
                        }
                        column = column2;
                    } else if ("TOP_N".equals(string)) {
                        StructType schema = StructType$.MODULE$.apply((Seq)measure.pra().map((Function1)new Serializable(this, measure){
                            public static final long serialVersionUID = 0L;
                            private final FunctionDesc measure$1;

                            public final StructField apply(ColumnDesc col) {
                                DataType dateType = col.dataType();
                                ColumnDesc columnDesc = col;
                                FunctionDesc functionDesc = this.measure$1;
                                return !(columnDesc != null ? !columnDesc.equals(functionDesc) : functionDesc != null) ? new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEASURE_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col.columnName()})), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()) : new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DIMENSION_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col.columnName()})), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                            }
                            {
                                this.measure$1 = measure$1;
                            }
                        }, List$.MODULE$.canBuildFrom()));
                        column = this.reuseLayout$1 ? new Column((Expression)new ReuseTopN(measure.returnType().precision(), schema, ((Column)columns.head()).expr(), ReuseTopN$.MODULE$.apply$default$4(), ReuseTopN$.MODULE$.apply$default$5()).toAggregateExpression()).as(id.toString()) : new Column((Expression)new EncodeTopN(measure.returnType().precision(), schema, ((Column)columns.head()).expr(), (Seq<Expression>)((Seq)((TraversableLike)columns.drop(1)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Expression apply(Column x$1) {
                                return x$1.expr();
                            }
                        }, ListBuffer$.MODULE$.canBuildFrom())), EncodeTopN$.MODULE$.apply$default$5(), EncodeTopN$.MODULE$.apply$default$6()).toAggregateExpression()).as(id.toString());
                    } else if ("PERCENTILE_APPROX".equals(string)) {
                        String udfName = UdfManager$.MODULE$.register(measure.returnType().toKylinDataType(), measure.expression(), null, !this.reuseLayout$1);
                        column = this.reuseLayout$1 ? functions$.MODULE$.callUDF(udfName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)columns.head()})).as(id.toString()) : functions$.MODULE$.callUDF(udfName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{((Column)columns.head()).cast((DataType)StringType$.MODULE$)})).as(id.toString());
                    } else {
                        column = functions$.MODULE$.max((Column)columns.head()).as(id.toString());
                    }
                    Column column3 = column;
                    return column3;
                }
                throw new MatchError(tuple2);
            }
            {
                this.dataSet$1 = dataSet$1;
                this.isSparkSql$1 = isSparkSql$1;
                this.reuseLayout$1 = reuseLayout$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Dataset dataset2 = df = dimensions.isEmpty() ? dataSet.agg((Column)agg2.head(), (Seq)agg2.drop(1)) : dataSet.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns(dimensions))).agg((Column)agg2.head(), (Seq)agg2.drop(1));
        if (reuseLayout) {
            Column[] columns = (Column[])Predef$.MODULE$.refArrayOps((Object[])NSparkCubingUtil.getColumns(dimensions)).$plus$plus(this.measureColumns(dataSet.schema(), measures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
        } else {
            dataset = df;
        }
        return dataset;
    }

    public AggregateFunction org$apache$kylin$engine$spark$job$CuboidAggregator$$getCountDistinctAggregate(ListBuffer<Column> columns, DTType returnType, boolean reuseLayout) {
        TypedImperativeAggregate typedImperativeAggregate;
        Column col = (Column)columns.head();
        if (this.isBitmap(returnType)) {
            typedImperativeAggregate = reuseLayout ? new ReusePreciseCountDistinct(col.expr(), ReusePreciseCountDistinct$.MODULE$.apply$default$2(), ReusePreciseCountDistinct$.MODULE$.apply$default$3()) : new EncodePreciseCountDistinct(this.wrapEncodeColumn((Column)columns.head()).expr(), EncodePreciseCountDistinct$.MODULE$.apply$default$2(), EncodePreciseCountDistinct$.MODULE$.apply$default$3());
        } else {
            int precision = returnType.precision();
            if (this.isMultiHllcCol(columns, returnType)) {
                col = this.wrapMutilHllcColumn((Seq<Column>)columns);
            }
            typedImperativeAggregate = reuseLayout ? new ReuseApproxCountDistinct(col.expr(), precision, ReuseApproxCountDistinct$.MODULE$.apply$default$3(), ReuseApproxCountDistinct$.MODULE$.apply$default$4()) : new EncodeApproxCountDistinct(col.expr(), precision, EncodeApproxCountDistinct$.MODULE$.apply$default$3(), EncodeApproxCountDistinct$.MODULE$.apply$default$4());
        }
        return typedImperativeAggregate;
    }

    /*
     * WARNING - void declaration
     */
    private StructType constructTopNSchema(List<ColumnDesc> parameters) {
        void var3_3;
        ColumnDesc measure = (ColumnDesc)parameters.head();
        StructType schema = StructType$.MODULE$.apply((Seq)parameters.map((Function1)new Serializable(measure){
            public static final long serialVersionUID = 0L;
            private final ColumnDesc measure$2;

            public final StructField apply(ColumnDesc col) {
                ColumnDesc columnDesc = col;
                ColumnDesc columnDesc2 = this.measure$2;
                return !(columnDesc != null ? !columnDesc.equals(columnDesc2) : columnDesc2 != null) ? new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEASURE_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col.columnName()})), col.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()) : new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DIMENSION_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col.columnName()})), col.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
            {
                this.measure$2 = measure$2;
            }
        }, List$.MODULE$.canBuildFrom()));
        return var3_3;
    }

    private boolean isMultiHllcCol(ListBuffer<Column> columns, DTType returnDataType) {
        return columns.length() > 1 && returnDataType.dataType().startsWith("hllc");
    }

    private boolean isBitmap(DTType returnDataType) {
        return returnDataType.dataType().equalsIgnoreCase("bitmap");
    }

    private Iterable<Column> measureColumns(StructType schema, Map<Integer, FunctionDesc> measures) {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Column apply(Tuple2<Integer, FunctionDesc> e) {
                Column column;
                String string = ((FunctionDesc)e._2()).expression().toUpperCase(Locale.ROOT);
                if ("SUM".equals(string)) {
                    String measureId = ((Integer)e._1()).toString();
                    DataType dataType = (DataType)this.schema$1.find((Function1)new Serializable(this, measureId){
                        public static final long serialVersionUID = 0L;
                        private final String measureId$1;

                        public final boolean apply(StructField x$2) {
                            return x$2.name().equals(this.measureId$1);
                        }
                        {
                            this.measureId$1 = measureId$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DataType apply(StructField x$3) {
                            return x$3.dataType();
                        }
                    }).get();
                    column = functions$.MODULE$.col(measureId).cast(dataType).as(measureId);
                } else {
                    String measureId = ((Integer)e._1()).toString();
                    column = functions$.MODULE$.col(measureId);
                }
                return column;
            }
            {
                this.schema$1 = schema$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Column wrapEncodeColumn(Column column) {
        return new Column(new StringBuilder().append((Object)column.toString()).append((Object)CubeBuilderHelper$.MODULE$.ENCODE_SUFFIX()).toString());
    }

    public Column wrapMutilHllcColumn(Seq<Column> columns) {
        ObjectRef col = ObjectRef.create((Object)functions$.MODULE$.when(functions$.MODULE$.isnull((Column)columns.head()), null));
        ((IterableLike)columns.drop(1)).foreach((Function1)new Serializable(col){
            public static final long serialVersionUID = 0L;
            private final ObjectRef col$1;

            public final void apply(Column inputCol) {
                this.col$1.elem = ((Column)this.col$1.elem).when(functions$.MODULE$.isnull(inputCol), null);
            }
            {
                this.col$1 = col$1;
            }
        });
        col.elem = ((Column)col.elem).otherwise((Object)functions$.MODULE$.hash(columns));
        return (Column)col.elem;
    }

    private CuboidAggregator$() {
        MODULE$ = this;
    }
}

