/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildLayoutWithUpdate {
    protected static final Logger logger = LoggerFactory.getLogger(BuildLayoutWithUpdate.class);
    private ExecutorService pool = Executors.newCachedThreadPool();
    private CompletionService<JobResult> completionService = new ExecutorCompletionService<JobResult>(this.pool);
    private int currentLayoutsNum = 0;

    public void submit(final JobEntity job, final KylinConfig config) {
        this.completionService.submit(new Callable<JobResult>(){

            @Override
            public JobResult call() throws Exception {
                KylinConfig.setAndUnsetThreadLocalConfig(config);
                Thread.currentThread().setName("thread-" + job.getName());
                LayoutEntity dataLayouts = null;
                Throwable throwable = null;
                try {
                    dataLayouts = job.build();
                }
                catch (Throwable t) {
                    logger.error("Error occurred when run " + job.getName(), t);
                    throwable = t;
                }
                return new JobResult(dataLayouts, throwable);
            }
        });
        ++this.currentLayoutsNum;
    }

    public void updateLayout(SegmentInfo seg, KylinConfig config) {
        for (int i = 0; i < this.currentLayoutsNum; ++i) {
            try {
                logger.info("Wait to take job result.");
                JobResult result = this.completionService.take().get();
                logger.info("Take job result successful.");
                if (result.isFailed()) {
                    this.shutDownPool();
                    throw new RuntimeException(result.getThrowable());
                }
                seg.updateLayout(result.layout);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                this.shutDownPool();
                throw new RuntimeException(e);
            }
        }
        this.currentLayoutsNum = 0;
    }

    private void shutDownPool() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred when shutdown thread pool.", e);
            this.pool.shutdownNow();
        }
    }

    static abstract class JobEntity {
        JobEntity() {
        }

        public abstract String getName();

        public abstract LayoutEntity build() throws IOException;
    }

    private static class JobResult {
        private LayoutEntity layout;
        private Throwable throwable;

        JobResult(LayoutEntity layout, Throwable throwable) {
            this.layout = layout;
            this.throwable = throwable;
        }

        boolean isFailed() {
            return this.throwable != null;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        LayoutEntity getLayout() {
            return this.layout;
        }
    }
}

