/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.util.Set;
import org.apache.kylin.engine.spark.builder.CubeBuilderHelper$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.spark.dict.NGlobalDictionary;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KylinFunctions$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class CubeTableEncoder$
implements Logging {
    public static final CubeTableEncoder$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CubeTableEncoder$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> encodeTable(Dataset<Row> ds, SegmentInfo seg, Set<ColumnDesc> cols) {
        StructType structType = ds.schema();
        ObjectRef partitionedDs = ObjectRef.create(ds);
        ds.sparkSession().sparkContext().setJobDescription("Encode count source data.");
        long sourceCnt = ds.count();
        int bucketThreshold = seg.kylinconf().getGlobalDictV2ThresholdBucketSize();
        long minBucketSize = sourceCnt / (long)bucketThreshold;
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(cols).asScala()).foreach((Function1)new Serializable(seg, structType, partitionedDs, minBucketSize){
            public static final long serialVersionUID = 0L;
            private final SegmentInfo seg$1;
            private final StructType structType$1;
            private final ObjectRef partitionedDs$1;
            private final long minBucketSize$1;

            public final void apply(ColumnDesc ref) {
                NGlobalDictionary globalDict = new NGlobalDictionary(this.seg$1.project(), ref.tableAliasName(), ref.columnName(), this.seg$1.kylinconf().getHdfsWorkingDirectory());
                int bucketSize = globalDict.getBucketSizeOrDefault(this.seg$1.kylinconf().getGlobalDictV2MinHashPartitions());
                int enlargedBucketSize = (int)((this.minBucketSize$1 / (long)bucketSize + 1L) * (long)bucketSize);
                String encodeColRef = NSparkCubingUtil.convertFromDot(ref.identity());
                int columnIndex = this.structType$1.fieldIndex(encodeColRef);
                String dictParams = Predef$.MODULE$.refArrayOps((Object[])new String[]{this.seg$1.project(), ref.tableAliasName(), ref.columnName(), this.seg$1.kylinconf().getHdfsWorkingDirectory()}).mkString(NSparkCubingUtil.SEPARATOR);
                String aliasName = this.structType$1.apply(columnIndex).name().concat(CubeBuilderHelper$.MODULE$.ENCODE_SUFFIX());
                Column encodeCol = KylinFunctions$.MODULE$.dict_encode(functions$.MODULE$.col(encodeColRef).cast((DataType)StringType$.MODULE$), functions$.MODULE$.lit((Object)dictParams), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketSize)).cast((DataType)StringType$.MODULE$)).as(aliasName);
                Seq columns = (Seq)((TraversableLike)((Dataset)this.partitionedDs$1.elem).schema().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Column apply(StructField ty) {
                        return functions$.MODULE$.col(ty.name());
                    }
                }, scala.collection.Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{encodeCol})), scala.collection.Seq$.MODULE$.canBuildFrom());
                this.partitionedDs$1.elem = ((Dataset)this.partitionedDs$1.elem).repartition(enlargedBucketSize, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(encodeColRef).cast((DataType)StringType$.MODULE$)})).select(columns);
            }
            {
                this.seg$1 = seg$1;
                this.structType$1 = structType$1;
                this.partitionedDs$1 = partitionedDs$1;
                this.minBucketSize$1 = minBucketSize$1;
            }
        });
        ds.sparkSession().sparkContext().setJobDescription(null);
        return (Dataset)partitionedDs.elem;
    }

    private CubeTableEncoder$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

