/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.LookupTable;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;

public class LookupStringTable
extends LookupTable<String>
implements ILookupTable {
    private static final Comparator<String> dateStrComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            long l1 = Long.parseLong(o1);
            long l2 = Long.parseLong(o2);
            return Long.compare(l1, l2);
        }
    };
    private static final Comparator<String> numStrComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            double d1 = Double.parseDouble(o1);
            double d2 = Double.parseDouble(o2);
            return Double.compare(d1, d2);
        }
    };
    private static final Comparator<String> defaultStrComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    boolean[] colIsDateTime;
    boolean[] colIsNumber;

    public LookupStringTable(TableDesc tableDesc, String[] keyColumns, IReadableTable table) throws IOException {
        super(tableDesc, keyColumns, table);
    }

    @Override
    protected void init() throws IOException {
        ColumnDesc[] cols = this.tableDesc.getColumns();
        this.colIsDateTime = new boolean[cols.length];
        this.colIsNumber = new boolean[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            DataType t = cols[i].getType();
            this.colIsDateTime[i] = t.isDateTimeFamily();
            this.colIsNumber[i] = t.isNumberFamily();
        }
        super.init();
    }

    protected String[] convertRow(String[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!this.colIsDateTime[i] || cols[i] == null) continue;
            cols[i] = String.valueOf(DateFormat.stringToMillis(cols[i]));
        }
        return cols;
    }

    @Override
    protected Comparator<String> getComparator(int idx) {
        if (this.colIsDateTime[idx]) {
            return dateStrComparator;
        }
        if (this.colIsNumber[idx]) {
            return numStrComparator;
        }
        return defaultStrComparator;
    }

    @Override
    protected String toString(String cell) {
        return cell;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public Iterator<String[]> iterator() {
        return this.data.values().iterator();
    }

    @Override
    public void close() throws IOException {
    }
}

