/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.IterableDictionaryValueEnumerator;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.HashMultimap;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.hash.HashFunction;
import org.apache.kylin.shaded.com.google.common.hash.Hasher;
import org.apache.kylin.shaded.com.google.common.hash.Hashing;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubingUtils {
    private static Logger logger = LoggerFactory.getLogger(CubingUtils.class);

    public static Map<Long, HLLCounter> sampling(CubeDesc cubeDesc, IJoinedFlatTableDesc flatDescIn, Iterable<List<String>> streams) {
        CubeJoinedFlatTableEnrich flatDesc = new CubeJoinedFlatTableEnrich(flatDescIn, cubeDesc);
        int rowkeyLength = cubeDesc.getRowkey().getRowKeyColumns().length;
        Set<Long> allCuboidIds = cubeDesc.getInitialCuboidScheduler().getAllCuboidIds();
        long baseCuboidId = Cuboid.getBaseCuboidId(cubeDesc);
        HashMap<Long, Integer[]> allCuboidsBitSet = Maps.newHashMap();
        HashMap<Long, HLLCounter> result = Maps.newHashMapWithExpectedSize(allCuboidIds.size());
        for (Long cuboidId : allCuboidIds) {
            result.put(cuboidId, new HLLCounter(cubeDesc.getConfig().getCubeStatsHLLPrecision()));
            Integer[] cuboidBitSet = new Integer[Long.bitCount(cuboidId)];
            long mask = Long.highestOneBit(baseCuboidId);
            int position = 0;
            for (int i = 0; i < rowkeyLength; ++i) {
                if ((mask & cuboidId) > 0L) {
                    cuboidBitSet[position] = i;
                    ++position;
                }
                mask >>= 1;
            }
            allCuboidsBitSet.put(cuboidId, cuboidBitSet);
        }
        HashFunction hf = Hashing.murmur3_32();
        byte[][] row_hashcodes = new byte[rowkeyLength][];
        for (List<String> row : streams) {
            for (int i = 0; i < rowkeyLength; ++i) {
                Hasher hc = hf.newHasher();
                String cell = row.get(flatDesc.getRowKeyColumnIndexes()[i]);
                row_hashcodes[i] = cell != null ? hc.putUnencodedChars(cell).hash().asBytes() : hc.putInt(0).hash().asBytes();
            }
            for (Map.Entry longHyperLogLogPlusCounterNewEntry : result.entrySet()) {
                Long cuboidId = (Long)longHyperLogLogPlusCounterNewEntry.getKey();
                HLLCounter counter = (HLLCounter)longHyperLogLogPlusCounterNewEntry.getValue();
                Hasher hc = hf.newHasher();
                Integer[] cuboidBitSet = (Integer[])allCuboidsBitSet.get(cuboidId);
                for (int position = 0; position < cuboidBitSet.length; ++position) {
                    hc.putBytes(row_hashcodes[cuboidBitSet[position]]);
                }
                counter.add(hc.hash().asBytes());
            }
        }
        return result;
    }

    public static Map<TblColRef, Dictionary<String>> buildDictionary(CubeInstance cubeInstance, Iterable<List<String>> recordList) throws IOException {
        List<TblColRef> columnsNeedToBuildDictionary = cubeInstance.getDescriptor().listDimensionColumnsExcludingDerived(true);
        HashMap<Integer, TblColRef> tblColRefMap = Maps.newHashMap();
        int index = 0;
        for (TblColRef column : columnsNeedToBuildDictionary) {
            tblColRefMap.put(index++, column);
        }
        HashMap<TblColRef, Dictionary<String>> result = Maps.newHashMap();
        HashMultimap valueMap = HashMultimap.create();
        for (List<String> row : recordList) {
            for (int i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                if (!tblColRefMap.containsKey(i)) continue;
                valueMap.put(tblColRefMap.get(i), cell);
            }
        }
        for (TblColRef tblColRef : valueMap.keySet()) {
            Set values = valueMap.get(tblColRef);
            Dictionary<String> dict = DictionaryGenerator.buildDictionary(tblColRef.getType(), new IterableDictionaryValueEnumerator(values));
            result.put(tblColRef, dict);
        }
        return result;
    }

    public static Map<TblColRef, Dictionary<String>> writeDictionary(CubeSegment cubeSegment, Map<TblColRef, Dictionary<String>> dictionaryMap, long startOffset, long endOffset) {
        HashMap<TblColRef, Dictionary<String>> realDictMap = Maps.newHashMap();
        for (Map.Entry<TblColRef, Dictionary<String>> entry : dictionaryMap.entrySet()) {
            TblColRef tblColRef = entry.getKey();
            Dictionary<String> dictionary = entry.getValue();
            IReadableTable.TableSignature signature = new IReadableTable.TableSignature();
            signature.setLastModifiedTime(System.currentTimeMillis());
            signature.setPath(String.format(Locale.ROOT, "streaming_%s_%s", startOffset, endOffset));
            signature.setSize(endOffset - startOffset);
            DictionaryInfo dictInfo = new DictionaryInfo(tblColRef.getColumnDesc(), tblColRef.getDatatype(), signature);
            logger.info("writing dictionary for TblColRef:" + tblColRef.toString());
            DictionaryManager dictionaryManager = DictionaryManager.getInstance(cubeSegment.getCubeDesc().getConfig());
            try {
                DictionaryInfo realDict = dictionaryManager.trySaveNewDict(dictionary, dictInfo);
                cubeSegment.putDictResPath(tblColRef, realDict.getResourcePath());
                realDictMap.put(tblColRef, realDict.getDictionaryObject());
            }
            catch (IOException e) {
                throw new RuntimeException("error save dictionary for column:" + tblColRef, e);
            }
        }
        return realDictMap;
    }
}

