/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.io.Serializable;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRowKeyEncoder
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractRowKeyEncoder.class);
    public static final byte DEFAULT_BLANK_BYTE = -1;
    protected byte blankByte = (byte)-1;
    protected final CubeSegment cubeSeg;
    protected Cuboid cuboid;

    public static AbstractRowKeyEncoder createInstance(CubeSegment cubeSeg, Cuboid cuboid) {
        return new RowKeyEncoder(cubeSeg, cuboid);
    }

    protected AbstractRowKeyEncoder(CubeSegment cubeSeg, Cuboid cuboid) {
        this.cuboid = cuboid;
        this.cubeSeg = cubeSeg;
    }

    public void setBlankByte(byte blankByte) {
        this.blankByte = blankByte;
    }

    public long getCuboidID() {
        return this.cuboid.getId();
    }

    public void setCuboid(Cuboid cuboid) {
        this.cuboid = cuboid;
    }

    public abstract byte[] createBuf();

    public abstract void encode(GTRecord var1, ImmutableBitSet var2, byte[] var3);

    public abstract void encode(ByteArray var1, ByteArray var2);

    public abstract byte[] encode(Map<TblColRef, String> var1);

    public abstract byte[] encode(String[] var1);
}

