/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.util.BitSet;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;

public final class InMemCubeBuilderUtils {
    public static final Pair<ImmutableBitSet, ImmutableBitSet> getDimensionAndMetricColumnBitSet(long cuboidId, int measureCount) {
        int cardinality = Long.bitCount(cuboidId);
        BitSet dimension = new BitSet();
        dimension.set(0, cardinality);
        BitSet metrics = new BitSet();
        metrics.set(cardinality, cardinality + measureCount);
        return Pair.newPair(new ImmutableBitSet(dimension), new ImmutableBitSet(metrics));
    }

    public static final Pair<ImmutableBitSet, ImmutableBitSet> getDimensionAndMetricColumnBitSet(long baseCuboidId, long childCuboidId, int measureCount) {
        Pair<ImmutableBitSet, ImmutableBitSet> parentDimensionAndMetricColumnBitSet = InMemCubeBuilderUtils.getDimensionAndMetricColumnBitSet(baseCuboidId, measureCount);
        ImmutableBitSet parentDimensions = parentDimensionAndMetricColumnBitSet.getFirst();
        ImmutableBitSet measureColumns2 = parentDimensionAndMetricColumnBitSet.getSecond();
        ImmutableBitSet childDimensions = parentDimensions;
        long mask = Long.highestOneBit(baseCuboidId);
        long parentCuboidIdActualLength = 64L - (long)Long.numberOfLeadingZeros(baseCuboidId);
        int index = 0;
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & baseCuboidId) > 0L) {
                if ((mask & childCuboidId) == 0L) {
                    childDimensions = childDimensions.set(index, false);
                }
                ++index;
            }
            mask >>= 1;
            ++i;
        }
        return Pair.newPair(childDimensions, measureColumns2);
    }
}

