/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.gridtable.TrimmedCubeCodeSystem;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.gridtable.DefaultGTComparator;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTComparator;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.DynamicDimSerializer;

public class CubeCodeSystem
implements IGTCodeSystem {
    GTInfo info;
    DimensionEncoding[] dimEncs;
    DataTypeSerializer[] serializers;
    IGTComparator comparator;
    Map<Integer, Integer> dependentMetricsMap;

    public CubeCodeSystem(DimensionEncoding[] dimEncs) {
        this(dimEncs, Collections.emptyMap());
    }

    public CubeCodeSystem(DimensionEncoding[] dimEncs, Map<Integer, Integer> dependentMetricsMap) {
        this.dimEncs = dimEncs;
        this.comparator = new DefaultGTComparator();
        this.dependentMetricsMap = dependentMetricsMap;
    }

    public TrimmedCubeCodeSystem trimForCoprocessor() {
        return new TrimmedCubeCodeSystem(this.dimEncs, this.dependentMetricsMap);
    }

    @Override
    public void init(GTInfo info) {
        this.info = info;
        ImmutableBitSet dDims = info.getDynamicDims();
        this.serializers = new DataTypeSerializer[info.getColumnCount()];
        for (int i = 0; i < this.serializers.length; ++i) {
            DimensionEncoding dimEnc;
            DimensionEncoding dimensionEncoding = dimEnc = i < this.dimEncs.length ? this.dimEncs[i] : null;
            if (dimEnc != null) {
                this.serializers[i] = dimEnc.asDataTypeSerializer();
                continue;
            }
            DataTypeSerializer<?> dSerializer = DataTypeSerializer.create(info.getColumnType(i));
            if (dDims != null && dDims.get(i)) {
                dSerializer = new DynamicDimSerializer(dSerializer);
            }
            this.serializers[i] = dSerializer;
        }
    }

    @Override
    public IGTComparator getComparator() {
        return this.comparator;
    }

    @Override
    public int codeLength(int col, ByteBuffer buf) {
        return this.serializers[col].peekLength(buf);
    }

    @Override
    public int maxCodeLength(int col) {
        return this.serializers[col].maxLength();
    }

    @Override
    public DimensionEncoding getDimEnc(int col) {
        if (col < this.dimEncs.length) {
            return this.dimEncs[col];
        }
        return null;
    }

    @Override
    public void encodeColumnValue(int col, Object value, ByteBuffer buf) {
        this.encodeColumnValue(col, value, 0, buf);
    }

    @Override
    public void encodeColumnValue(int col, Object value, int roundingFlag, ByteBuffer buf) {
        DataTypeSerializer<Object> serializer = this.serializers[col];
        if (serializer instanceof DictionaryDimEnc.DictionarySerializer) {
            DictionaryDimEnc dictEnc = (DictionaryDimEnc)this.dimEncs[col];
            if (dictEnc.getRoundingFlag() != roundingFlag) {
                serializer = dictEnc.copy(roundingFlag).asDataTypeSerializer();
            }
            try {
                serializer.serialize(value, buf);
            }
            catch (IllegalArgumentException ex) {
                IllegalArgumentException rewordEx = new IllegalArgumentException("Column " + col + " value '" + this.toStringBinary(value) + "' met dictionary error: " + ex.getMessage());
                rewordEx.setStackTrace(ex.getStackTrace());
                throw rewordEx;
            }
        } else {
            if (value instanceof String) {
                value = serializer.valueOf((String)value);
            }
            serializer.serialize(value, buf);
        }
    }

    private String toStringBinary(Object value) {
        if (value == null) {
            return "Null";
        }
        byte[] bytes = value.toString().getBytes(Charset.forName("UTF-8"));
        return Bytes.toStringBinary(bytes);
    }

    @Override
    public Object decodeColumnValue(int col, ByteBuffer buf) {
        return this.serializers[col].deserialize(buf);
    }

    @Override
    public MeasureAggregator<?>[] newMetricsAggregators(ImmutableBitSet columns, String[] aggrFunctions) {
        assert (columns.trueBitCount() == aggrFunctions.length);
        MeasureAggregator[] result = new MeasureAggregator[aggrFunctions.length];
        for (int i = 0; i < result.length; ++i) {
            int col = columns.trueBitAt(i);
            result[i] = MeasureAggregator.create(aggrFunctions[i], this.info.getColumnType(col));
        }
        if (this.dependentMetricsMap != null) {
            for (Map.Entry<Integer, Integer> childEntry : this.dependentMetricsMap.entrySet()) {
                if (!columns.get(childEntry.getKey())) continue;
                Integer parent = childEntry.getValue();
                if (!columns.get(parent)) {
                    throw new IllegalStateException();
                }
                int childIdx = columns.trueBitIndexOf(childEntry.getKey());
                int parentIdx = columns.trueBitIndexOf(parent);
                result[childIdx].setDependentAggregator(result[parentIdx]);
            }
        }
        return result;
    }

    @Override
    public DataTypeSerializer<?> getSerializer(int col) {
        return this.serializers[col];
    }
}

