/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.common.TupleFilterNode;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPruner {
    private static final Logger logger = LoggerFactory.getLogger(SegmentPruner.class);
    private TupleFilterNode node;

    public SegmentPruner(TupleFilter filter2) {
        this.node = new TupleFilterNode(filter2);
    }

    public List<CubeSegment> listSegmentsForQuery(CubeInstance cube) {
        ArrayList<CubeSegment> r = new ArrayList<CubeSegment>();
        for (CubeSegment seg : cube.getSegments(SegmentStatusEnum.READY)) {
            if (!this.check(seg)) continue;
            r.add(seg);
        }
        return r;
    }

    public boolean check(CubeSegment seg) {
        if (seg.getInputRecords() == 0L) {
            if (seg.getConfig().isSkippingEmptySegments()) {
                logger.debug("Prune segment {} due to 0 input record", (Object)seg);
                return false;
            }
            logger.debug("Insist scan of segment {} having 0 input record", (Object)seg);
        }
        if (!this.node.checkSeg(seg)) {
            logger.debug("Prune segment {} due to given filter", (Object)seg);
            return false;
        }
        logger.debug("Pruner passed on segment {}", (Object)seg);
        return true;
    }

    public static DimensionRangeInfo tryDeduceRangeFromPartitionCol(CubeSegment seg, TblColRef col) {
        DataModelDesc model = seg.getModel();
        PartitionDesc part = model.getPartitionDesc();
        if (!part.isPartitioned()) {
            return null;
        }
        if (!col.equals(part.getPartitionDateColumnRef())) {
            return null;
        }
        SegmentRange.TSRange tsRange = seg.getTSRange();
        if (tsRange.start.isMin || tsRange.end.isMax) {
            return null;
        }
        String min = SegmentPruner.tsRangeToStr((Long)tsRange.start.v, part);
        String max = SegmentPruner.tsRangeToStr((Long)tsRange.end.v - 1L, part);
        return new DimensionRangeInfo(min, max);
    }

    private static String tsRangeToStr(long ts, PartitionDesc part) {
        String value;
        DataType partitionColType = part.getPartitionDateColumnRef().getType();
        if (partitionColType.isDate()) {
            value = DateFormat.formatToDateStr(ts);
        } else if (partitionColType.isTimeFamily()) {
            value = DateFormat.formatToTimeWithoutMilliStr(ts);
        } else if (partitionColType.isStringFamily() || partitionColType.isIntegerFamily()) {
            String partitionDateFormat = part.getPartitionDateFormat();
            value = StringUtils.isEmpty(partitionDateFormat) ? "" + ts : DateFormat.formatToDateStr(ts, partitionDateFormat);
        } else {
            throw new RuntimeException("Type " + partitionColType + " is not valid partition column type");
        }
        return value;
    }

    public static boolean satisfy(CompareTupleFilter comp, String minVal, String maxVal) {
        if (minVal == null && maxVal == null) {
            return true;
        }
        if (comp.getChildren().size() > 1 && !(comp.getChildren().get(1) instanceof ConstantTupleFilter)) {
            return true;
        }
        TblColRef col = comp.getColumn();
        DataTypeOrder order = col.getType().getOrder();
        String filterVal = SegmentPruner.toString(comp.getFirstValue());
        switch (comp.getOperator()) {
            case EQ: 
            case IN: {
                for (String filterValue : comp.getValues()) {
                    if (order.compare(filterValue, maxVal) > 0 || order.compare(minVal, filterValue) > 0) continue;
                    return true;
                }
                return false;
            }
            case LT: {
                return order.compare(minVal, filterVal) < 0;
            }
            case LTE: {
                return order.compare(minVal, filterVal) <= 0;
            }
            case GT: {
                return order.compare(maxVal, filterVal) > 0;
            }
            case GTE: {
                return order.compare(maxVal, filterVal) >= 0;
            }
        }
        return true;
    }

    private static String toString(Object v) {
        return v == null ? null : v.toString();
    }
}

