/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.metadata.filter.UDF.MassInTupleFilter;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeCapabilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(CubeCapabilityChecker.class);

    public static CapabilityResult check(CubeInstance cube, SQLDigest digest2) {
        CapabilityResult result = new CapabilityResult();
        result.capable = false;
        Collection<TblColRef> dimensionColumns = CubeCapabilityChecker.getDimensionColumns(digest2);
        List<FunctionDesc> aggrFunctions = digest2.aggregations;
        Set<TblColRef> unmatchedDimensions = CubeCapabilityChecker.unmatchedDimensions(dimensionColumns, cube);
        Set<FunctionDesc> unmatchedAggregations = CubeCapabilityChecker.unmatchedAggregations(aggrFunctions, cube);
        CubeCapabilityChecker.tryCustomMeasureTypes(unmatchedDimensions, unmatchedAggregations, digest2, cube, result);
        String rootFactTable = cube.getRootFactTable();
        if (rootFactTable.equals(digest2.factTable)) {
            if (!unmatchedAggregations.isEmpty()) {
                CubeCapabilityChecker.removeUnmatchedGroupingAgg(unmatchedAggregations);
                CubeCapabilityChecker.tryDimensionAsMeasures(unmatchedAggregations, result, cube.getDescriptor().listDimensionColumnsIncludingDerived());
            }
        } else {
            CubeSegment latestReadySeg = cube.getLatestReadySegment();
            if (latestReadySeg != null && latestReadySeg.getSnapshots().containsKey(digest2.factTable) || cube.getSnapshots().containsKey(digest2.factTable)) {
                HashSet<TblColRef> dimCols = Sets.newHashSet(cube.getModel().findFirstTable(digest2.factTable).getColumns());
                if (!unmatchedAggregations.isEmpty()) {
                    Iterator itr = unmatchedAggregations.iterator();
                    while (itr.hasNext()) {
                        FunctionDesc functionDesc = (FunctionDesc)itr.next();
                        if (!dimCols.containsAll(functionDesc.getParameter().getColRefs())) continue;
                        itr.remove();
                    }
                }
                CubeCapabilityChecker.tryDimensionAsMeasures(Lists.newArrayList(aggrFunctions), result, dimCols);
                if (!unmatchedDimensions.isEmpty()) {
                    unmatchedDimensions.removeAll(dimCols);
                }
            } else {
                logger.info("cube {} does not touch lookup table {} at all", (Object)cube.getName(), (Object)digest2.factTable);
                return result;
            }
        }
        if (!unmatchedDimensions.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched dimensions: " + unmatchedDimensions);
            result.incapableCause = CapabilityResult.IncapableCause.unmatchedDimensions(unmatchedDimensions);
            return result;
        }
        if (!unmatchedAggregations.isEmpty()) {
            logger.info("Exclude cube " + cube.getName() + " because unmatched aggregations: " + unmatchedAggregations);
            result.incapableCause = CapabilityResult.IncapableCause.unmatchedAggregations(unmatchedAggregations);
            return result;
        }
        if (cube.getStorageType() == 0 && MassInTupleFilter.containsMassInTupleFilter(digest2.filter)) {
            logger.info("Exclude cube " + cube.getName() + " because only v2 storage + v2 query engine supports massin");
            result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.UNSUPPORT_MASSIN);
            return result;
        }
        if (digest2.limitPrecedesAggr) {
            logger.info("Exclude cube " + cube.getName() + " because there's limit preceding aggregation");
            result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.LIMIT_PRECEDE_AGGR);
            return result;
        }
        if (digest2.isRawQuery && rootFactTable.equals(digest2.factTable)) {
            if (cube.getConfig().isDisableCubeNoAggSQL()) {
                result.incapableCause = CapabilityResult.IncapableCause.create(CapabilityResult.IncapableType.UNSUPPORT_RAWQUERY);
                return result;
            }
            result.influences.add(new CapabilityResult.CapabilityInfluence(){

                @Override
                public double suggestCostMultiplier() {
                    return 100.0;
                }

                @Override
                public MeasureDesc getInvolvedMeasure() {
                    return null;
                }
            });
        }
        result.capable = true;
        return result;
    }

    private static Collection<TblColRef> getDimensionColumns(SQLDigest sqlDigest) {
        List<TblColRef> groupByColumns = sqlDigest.groupbyColumns;
        Set<TblColRef> filterColumns = sqlDigest.filterColumns;
        Set<TblColRef> rtDimColumns = sqlDigest.rtDimensionColumns;
        HashSet<TblColRef> dimensionColumns = new HashSet<TblColRef>();
        dimensionColumns.addAll(groupByColumns);
        dimensionColumns.addAll(filterColumns);
        dimensionColumns.addAll(rtDimColumns);
        return dimensionColumns;
    }

    private static Set<TblColRef> unmatchedDimensions(Collection<TblColRef> dimensionColumns, CubeInstance cube) {
        HashSet<TblColRef> result = Sets.newHashSet(dimensionColumns);
        CubeDesc cubeDesc = cube.getDescriptor();
        result.removeAll(cubeDesc.listDimensionColumnsIncludingDerived());
        return result;
    }

    private static Set<FunctionDesc> unmatchedAggregations(Collection<FunctionDesc> aggregations, CubeInstance cube) {
        HashSet<FunctionDesc> result = Sets.newHashSet(aggregations);
        CubeDesc cubeDesc = cube.getDescriptor();
        List<FunctionDesc> definedFuncs = cubeDesc.listAllFunctions();
        result.removeAll(definedFuncs);
        Iterator<FunctionDesc> funcIterator = result.iterator();
        while (funcIterator.hasNext()) {
            FunctionDesc entry = funcIterator.next();
            if (!(entry instanceof DynamicFunctionDesc)) continue;
            DynamicFunctionDesc dynFunc = (DynamicFunctionDesc)entry;
            Collection<TblColRef> definedCols = dynFunc.ifFriendlyForDerivedFilter() ? cubeDesc.listDimensionColumnsIncludingDerived() : cubeDesc.listDimensionColumnsExcludingDerived(true);
            HashSet<TblColRef> filterCols2 = Sets.newHashSet(dynFunc.getFilterColumnSet());
            filterCols2.removeAll(definedCols);
            if (!filterCols2.isEmpty()) continue;
            HashSet<FunctionDesc> innerFuncSet = Sets.newHashSet(dynFunc.getRuntimeFuncs());
            innerFuncSet.removeAll(definedFuncs);
            if (!innerFuncSet.isEmpty()) continue;
            funcIterator.remove();
        }
        return result;
    }

    private static void tryDimensionAsMeasures(Collection<FunctionDesc> unmatchedAggregations, CapabilityResult result, Set<TblColRef> dimCols) {
        Iterator<FunctionDesc> it = unmatchedAggregations.iterator();
        while (it.hasNext()) {
            List<TblColRef> neededCols;
            FunctionDesc functionDesc = it.next();
            if (functionDesc.isCount()) {
                logger.warn("No count measure found for column {}, will use count(1) to replace it, please note that it will count all value(include null value)", (Object)(functionDesc.getParameter() == null ? "" : functionDesc.getParameter().getColRef().getName()));
                it.remove();
                continue;
            }
            ParameterDesc parameterDesc = functionDesc.getParameter();
            if (parameterDesc == null || (neededCols = parameterDesc.getColRefs()).size() <= 0 || !dimCols.containsAll(neededCols) || !FunctionDesc.BUILT_IN_AGGREGATIONS.contains(functionDesc.getExpression())) continue;
            result.influences.add(new CapabilityResult.DimensionAsMeasure(functionDesc));
            it.remove();
        }
    }

    private static void tryCustomMeasureTypes(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest2, CubeInstance cube, CapabilityResult result) {
        CubeDesc cubeDesc = cube.getDescriptor();
        ArrayList<String> influencingMeasures = Lists.newArrayList();
        for (MeasureDesc measure : cubeDesc.getMeasures()) {
            CapabilityResult.CapabilityInfluence inf;
            MeasureType<?> measureType = measure.getFunction().getMeasureType();
            if (measureType instanceof BasicMeasureType || (inf = measureType.influenceCapabilityCheck(unmatchedDimensions, unmatchedAggregations, digest2, measure)) == null) continue;
            result.influences.add(inf);
            influencingMeasures.add(measure.getName() + "@" + measureType.getClass());
        }
        if (influencingMeasures.size() != 0) {
            logger.info("Cube {} CapabilityInfluences: {}", (Object)cube.getCanonicalName(), (Object)StringUtils.join(influencingMeasures, ","));
        }
    }

    private static void removeUnmatchedGroupingAgg(Collection<FunctionDesc> unmatchedAggregations) {
        if (CollectionUtils.isEmpty(unmatchedAggregations)) {
            return;
        }
        Iterator<FunctionDesc> iterator = unmatchedAggregations.iterator();
        while (iterator.hasNext()) {
            if (!"GROUPING".equalsIgnoreCase(iterator.next().getExpression())) continue;
            iterator.remove();
        }
    }
}

