/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.kylin.common.util.TimeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TimeUtilTest {
    public static long normalizeTime(long timeMillis, NormalizedTimeUnit unit) {
        Calendar a = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        Calendar b = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
        b.clear();
        a.setTimeInMillis(timeMillis);
        if (unit == NormalizedTimeUnit.MINUTE) {
            b.set(a.get(1), a.get(2), a.get(5), a.get(11), a.get(12));
        } else if (unit == NormalizedTimeUnit.HOUR) {
            b.set(a.get(1), a.get(2), a.get(5), a.get(11), 0);
        }
        return b.getTimeInMillis();
    }

    @Test
    public void basicTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ROOT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        long t1 = dateFormat.parse("2012/01/01 00:00:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart(t1));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart(t1));
        long t2 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart(t2));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart(t2));
        long t3 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/12/31 00:00:00").getTime(), (long)TimeUtil.getDayStart(t3));
        Assert.assertEquals((long)dateFormat.parse("2012/12/30 00:00:00").getTime(), (long)TimeUtil.getWeekStart(t3));
        Assert.assertEquals((long)dateFormat.parse("2012/12/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart(t3));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart(t3));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart(t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/6 00:00:00").getTime(), (long)TimeUtil.getWeekEnd(t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getMonthEnd(t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEnd(t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEnd(t3));
        long t4 = dateFormat.parse("2012/10/29 11:02:01").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/10/29 00:00:00").getTime(), (long)TimeUtil.getDayStart(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/28 00:00:00").getTime(), (long)TimeUtil.getWeekStart(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/11/4 00:00:00").getTime(), (long)TimeUtil.getWeekEnd(t4));
        Assert.assertEquals((long)dateFormat.parse("2012/11/1 00:00:00").getTime(), (long)TimeUtil.getMonthEnd(t4));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEnd(t4));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEnd(t4));
        long t5 = dateFormat.parse("2012/8/29 23:12:41").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/8/29 00:00:00").getTime(), (long)TimeUtil.getDayStart(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/8/26 00:00:00").getTime(), (long)TimeUtil.getWeekStart(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/8/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/7/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/9/2 00:00:00").getTime(), (long)TimeUtil.getWeekEnd(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/9/1 00:00:00").getTime(), (long)TimeUtil.getMonthEnd(t5));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEnd(t5));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEnd(t5));
        long t6 = dateFormat.parse("2015/01/01 10:01:30").getTime();
        Assert.assertEquals((long)dateFormat.parse("2015/01/01 00:00:00").getTime(), (long)TimeUtil.getDayStart(t6));
        Assert.assertEquals((long)dateFormat.parse("2014/12/28 00:00:00").getTime(), (long)TimeUtil.getWeekStart(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/4 00:00:00").getTime(), (long)TimeUtil.getWeekEnd(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/2/1 00:00:00").getTime(), (long)TimeUtil.getMonthEnd(t6));
        Assert.assertEquals((long)dateFormat.parse("2015/4/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEnd(t6));
        Assert.assertEquals((long)dateFormat.parse("2016/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEnd(t6));
    }

    @Test
    public void basicTestWithTimeZone() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ROOT);
        TimeZone timeZone = TimeZone.getTimeZone("GMT+8");
        dateFormat.setTimeZone(timeZone);
        long t1 = dateFormat.parse("2012/01/01 00:00:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart(t1));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart(t1));
        long t2 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart(t2));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart(t2));
        long t3 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/12/31 00:00:00").getTime(), (long)TimeUtil.getDayStartWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2012/12/30 00:00:00").getTime(), (long)TimeUtil.getWeekStartWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2012/12/1 00:00:00").getTime(), (long)TimeUtil.getMonthStartWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStartWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStartWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/6 00:00:00").getTime(), (long)TimeUtil.getWeekEndWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getMonthEndWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEndWithTimeZone(timeZone, t3));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEndWithTimeZone(timeZone, t3));
        long t4 = dateFormat.parse("2012/10/29 11:02:01").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/10/29 00:00:00").getTime(), (long)TimeUtil.getDayStartWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/28 00:00:00").getTime(), (long)TimeUtil.getWeekStartWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getMonthStartWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStartWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStartWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/11/4 00:00:00").getTime(), (long)TimeUtil.getWeekEndWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2012/11/1 00:00:00").getTime(), (long)TimeUtil.getMonthEndWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEndWithTimeZone(timeZone, t4));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEndWithTimeZone(timeZone, t4));
        long t5 = dateFormat.parse("2012/8/29 23:12:41").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/8/29 00:00:00").getTime(), (long)TimeUtil.getDayStartWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/8/26 00:00:00").getTime(), (long)TimeUtil.getWeekStartWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/8/1 00:00:00").getTime(), (long)TimeUtil.getMonthStartWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/7/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStartWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStartWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/9/2 00:00:00").getTime(), (long)TimeUtil.getWeekEndWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/9/1 00:00:00").getTime(), (long)TimeUtil.getMonthEndWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEndWithTimeZone(timeZone, t5));
        Assert.assertEquals((long)dateFormat.parse("2013/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEndWithTimeZone(timeZone, t5));
        long t6 = dateFormat.parse("2015/01/01 10:01:30").getTime();
        Assert.assertEquals((long)dateFormat.parse("2015/01/01 00:00:00").getTime(), (long)TimeUtil.getDayStartWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2014/12/28 00:00:00").getTime(), (long)TimeUtil.getWeekStartWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getMonthStartWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStartWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStartWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/1/4 00:00:00").getTime(), (long)TimeUtil.getWeekEndWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/2/1 00:00:00").getTime(), (long)TimeUtil.getMonthEndWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2015/4/1 00:00:00").getTime(), (long)TimeUtil.getQuarterEndWithTimeZone(timeZone, t6));
        Assert.assertEquals((long)dateFormat.parse("2016/1/1 00:00:00").getTime(), (long)TimeUtil.getYearEndWithTimeZone(timeZone, t6));
    }

    public static enum NormalizedTimeUnit {
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

