/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.tool.shaded.org.apache.commons.io.Charsets;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempMetadataBuilder {
    public static final String N_SPARK_PROJECT_KYLIN_META_TEST_DATA = "../../examples/test_case_data/parquet_test";
    public static final String N_SPARK_PROJECT_KYLIN_META_TEST_DATA_2 = "../examples/test_case_data/parquet_test";
    public static final String TEMP_TEST_METADATA = "../examples/test_metadata";
    private static final Logger logger = LoggerFactory.getLogger(TempMetadataBuilder.class);
    private String[] metaSrcs = null;
    private boolean debug = false;
    private String dst;

    public static String prepareNLocalTempMetadata() {
        return TempMetadataBuilder.prepareNLocalTempMetadata(false);
    }

    public static String prepareNLocalTempMetadata(boolean debug) {
        if (new File(N_SPARK_PROJECT_KYLIN_META_TEST_DATA).exists()) {
            return new TempMetadataBuilder(debug, "../../examples/test_metadata", N_SPARK_PROJECT_KYLIN_META_TEST_DATA).build();
        }
        return new TempMetadataBuilder(debug, TEMP_TEST_METADATA, N_SPARK_PROJECT_KYLIN_META_TEST_DATA_2).build();
    }

    public static String prepareNLocalTempMetadata(boolean debug, String overlay) {
        if (new File(overlay).exists()) {
            return new TempMetadataBuilder(debug, "../../examples/test_metadata", overlay).build();
        }
        return new TempMetadataBuilder(debug, TEMP_TEST_METADATA, overlay).build();
    }

    private TempMetadataBuilder(boolean debug, String dst, String ... metaSrcs) {
        this.metaSrcs = metaSrcs;
        this.debug = debug;
        this.dst = dst;
    }

    private String build() {
        logger.debug("Prepare temp metadata for ut/it .");
        if ("true".equals(System.getProperty("skipMetaPrep"))) {
            return this.dst;
        }
        try {
            if (this.debug) {
                logger.info("Preparing local temp metadata");
                for (String metaSrc : this.metaSrcs) {
                    logger.info("Found one META_TEST_SRC: {}", (Object)new File(metaSrc).getCanonicalPath());
                }
                logger.info("TEMP_TEST_METADATA={}", (Object)new File(TEMP_TEST_METADATA).getCanonicalPath());
            }
            FileUtils.deleteQuietly(new File(this.dst));
            for (String metaSrc : this.metaSrcs) {
                FileUtils.copyDirectory(new File(metaSrc), new File(this.dst));
            }
            this.appendKylinProperties(this.dst);
            if (this.debug) {
                File copy = new File(this.dst + ".debug");
                FileUtils.deleteDirectory(copy);
                FileUtils.copyDirectory(new File(this.dst), copy);
                logger.info("Make copy for debug: {}", (Object)copy.getCanonicalPath());
            }
            return this.dst;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendKylinProperties(String tempMetadataDir) throws IOException {
        File propsFile = new File(tempMetadataDir, "kylin.properties");
        File appendFile = new File(tempMetadataDir, "kylin.properties.append");
        if (appendFile.exists()) {
            if (this.debug) {
                logger.info("Appending kylin.properties from {}", (Object)appendFile.getCanonicalPath());
            }
            String appendStr = FileUtils.readFileToString(appendFile, Charsets.UTF_8);
            FileUtils.writeStringToFile(propsFile, appendStr, Charsets.UTF_8, true);
            FileUtils.deleteQuietly(appendFile);
        }
    }

    private void overrideEngineTypeAndStorageType(String tempMetadataDir, Pair<Integer, Integer> typePair, List<String> includeFiles) throws IOException {
        File cubeDescDir;
        File[] cubeDescFiles;
        int engineType = typePair.getFirst();
        int storageType = typePair.getSecond();
        if (this.debug) {
            logger.info("Override engine type to be {}", (Object)engineType);
            logger.info("Override storage type to be {}", (Object)storageType);
        }
        if ((cubeDescFiles = (cubeDescDir = new File(tempMetadataDir, "cube_desc")).listFiles()) == null) {
            return;
        }
        for (File f : cubeDescFiles) {
            if (includeFiles != null && !includeFiles.contains(f.getName())) continue;
            if (this.debug) {
                logger.info("Process override {}", (Object)f.getCanonicalPath());
            }
            List<String> lines = FileUtils.readLines(f, Charsets.UTF_8);
            int n = lines.size();
            for (int i = 0; i < n; ++i) {
                String l = lines.get(i);
                if (l.contains("\"engine_type\"")) {
                    lines.set(i, "  \"engine_type\" : " + engineType + ",");
                }
                if (!l.contains("\"storage_type\"")) continue;
                lines.set(i, "  \"storage_type\" : " + storageType + ",");
            }
            FileUtils.writeLines(f, "UTF-8", lines);
        }
    }

    private Pair<Integer, Integer> grabDefaultEngineTypes(String tempMetadataDir) throws IOException {
        String tmp;
        int engineType = -1;
        int storageType = -1;
        List<String> lines = FileUtils.readLines(new File(tempMetadataDir, "kylin.properties"), Charsets.UTF_8);
        for (String l : lines) {
            if (l.startsWith("kylin.engine.default")) {
                engineType = Integer.parseInt(l.substring(l.lastIndexOf(61) + 1).trim());
            }
            if (!l.startsWith("kylin.storage.default")) continue;
            storageType = Integer.parseInt(l.substring(l.lastIndexOf(61) + 1).trim());
        }
        if (this.debug) {
            logger.info("Grap from kylin.properties, engine type is {}", (Object)engineType);
            logger.info("Grap from kylin.properties, storage type is {}", (Object)storageType);
        }
        if (!StringUtils.isBlank(tmp = System.getProperty("kylin.engine"))) {
            engineType = Integer.parseInt(tmp.trim());
            if (this.debug) {
                logger.info("By system property, engine type is {}", (Object)engineType);
            }
        }
        if (!StringUtils.isBlank(tmp = System.getProperty("kylin.storage"))) {
            storageType = Integer.parseInt(tmp.trim());
            if (this.debug) {
                logger.info("By system property, storage type is {}", (Object)storageType);
            }
        }
        if (engineType < 0 || storageType < 0) {
            throw new IllegalStateException();
        }
        return Pair.newPair(engineType, storageType);
    }
}

