/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.LinkedList;
import org.apache.kylin.common.util.SumHelper;
import org.junit.Assert;
import org.junit.Test;

public class SumHelperTest {
    @Test
    public void testSumDouble() {
        LinkedList<Double> linkedList = new LinkedList<Double>();
        Double doubleValue = new Double(2832.0);
        linkedList.add(doubleValue);
        Double result = SumHelper.sumDouble(linkedList);
        Assert.assertTrue((boolean)linkedList.contains(result));
        Assert.assertEquals((double)result, (double)doubleValue, (double)0.01);
        Assert.assertEquals((double)2832.0, (double)result, (double)0.01);
        Assert.assertEquals((long)1L, (long)linkedList.size());
    }

    @Test
    public void testSumIntegerReturningLongWhereShortValueIsPositive() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer integer = 4584;
        linkedList.add(integer);
        Long result = SumHelper.sumInteger(linkedList);
        Assert.assertTrue((boolean)linkedList.contains(integer));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)4584L, (long)result);
        Assert.assertEquals((long)1L, (long)linkedList.size());
    }

    @Test
    public void testSumLong() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Long resultOne = SumHelper.sumInteger(linkedList);
        Assert.assertEquals((long)0L, (long)resultOne);
        Assert.assertEquals((long)0L, (long)linkedList.size());
        LinkedList<Long> linkedListTwo = new LinkedList<Long>();
        linkedListTwo.add(resultOne);
        Long resultTwo = SumHelper.sumLong(linkedListTwo);
        Assert.assertEquals((long)0L, (long)resultTwo);
        Assert.assertEquals((long)1L, (long)linkedListTwo.size());
    }
}

