/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void splitTest() {
        String normalText = "Try to make the code better";
        Object[] expected = new String[]{"Try", "to", "make", "the", "code", "better"};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.split(normalText, " "));
        expected = new String[]{""};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.split("", ":"));
        expected = new String[]{"", ""};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.split(":", ":"));
        expected = new String[]{"1", "2"};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.split("1<|>2", "<|>"));
    }

    @Test
    public void splitAndTrimTest() {
        Object[] expected = new String[]{"foo", "bar"};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.splitAndTrim(" foo... bar. ", "."));
    }

    @Test
    public void splitByCommaTest() {
        Object[] expected = new String[]{"Hello", "Kylin"};
        Assert.assertArrayEquals((Object[])expected, (Object[])StringUtil.splitByComma("Hello,Kylin"));
    }

    @Test
    public void testJoin() {
        ArrayList<String> stringListNormal = Lists.newArrayList();
        ArrayList<String> stringListEmpty = Lists.newArrayList();
        stringListNormal.add("aaa");
        stringListNormal.add("bbb");
        stringListNormal.add("ccc");
        String joinedNormal = StringUtil.join(stringListNormal, ",");
        Assert.assertEquals((Object)"aaa,bbb,ccc", (Object)joinedNormal);
        stringListEmpty.add("");
        stringListEmpty.add("aa");
        stringListEmpty.add("");
        stringListEmpty.add("bb");
        stringListEmpty.add("");
        String joinedEmpty = StringUtil.join(stringListEmpty, ",");
        Assert.assertEquals((Object)",aa,,bb,", (Object)joinedEmpty);
    }

    @Test
    public void testDropSuffixWithNonEmptyString() {
        Assert.assertEquals((Object)"", (Object)StringUtil.dropSuffix("Oo}T^z88/U", "Oo}T^z88/U"));
    }

    @Test
    public void testDropSuffixWithEmptyString() {
        String string = StringUtil.dropSuffix("", "^Fahs");
        Assert.assertEquals((Object)"", (Object)string);
    }

    @Test
    public void testNoBlankWithNull() {
        Assert.assertEquals((Object)"%W=U~)O|0'#?,zA", (Object)StringUtil.noBlank(null, "%W=U~)O|0'#?,zA"));
    }

    @Test
    public void testNoBlankWithNonEmptyString() {
        Assert.assertEquals((Object)"N(sg", (Object)StringUtil.noBlank("N(sg", "H=!Cp(Ed5gral\u007f0qzo"));
    }

    @Test
    public void testToUpperCaseArrayWithNonEmptyArray() {
        String[] stringArray = new String[7];
        stringArray[0] = "org.apache.kylin.common.util.StringUtil";
        StringUtil.toUpperCaseArray(stringArray, stringArray);
        Assert.assertEquals((long)7L, (long)stringArray.length);
        Assert.assertEquals((Object)"[ORG.APACHE.KYLIN.COMMON.UTIL.STRINGUTIL, null, null, null, null, null, null]", (Object)Arrays.asList(stringArray).toString());
    }

    @Test
    public void testJoinReturningNonEmptyString() {
        ArrayList arrayList = new ArrayList();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(arrayList);
        linkedHashSet.add(")'<Mw@ZR0IYF_l%*>");
        linkedHashSet.add(null);
        String resultString = StringUtil.join(linkedHashSet, null);
        Assert.assertNotNull((Object)resultString);
        Assert.assertEquals((Object)")'<Mw@ZR0IYF_l%*>", (Object)resultString);
    }

    @Test
    public void testJoinOne() {
        Vector<String> vector = new Vector<String>();
        vector.add(null);
        String resultString = StringUtil.join(vector, "PB");
        Assert.assertNotNull((Object)resultString);
        Assert.assertEquals((Object)"", (Object)resultString);
    }

    @Test
    public void testJoinTwo() {
        Set<String> set = Locale.CHINESE.getUnicodeLocaleAttributes();
        String resultString = StringUtil.join(set, "Op");
        Assert.assertTrue((boolean)set.isEmpty());
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertNotNull((Object)resultString);
        Assert.assertEquals((Object)"", (Object)resultString);
    }

    @Test
    public void testJoinReturningNull() {
        String string = StringUtil.join(null, ")Y>1v&V0GU6a");
        Assert.assertNull((Object)string);
    }

    @Test
    public void testTrimSuffixWithEmptyString() {
        String string = StringUtil.trimSuffix(" 8VKQ&I*pSVr", "");
        Assert.assertEquals((Object)" 8VKQ&I*pSVr", (Object)string);
    }

    @Test
    public void testTrimSuffixWithNonEmptyString() {
        String string = StringUtil.trimSuffix(",", "5I;.t0F*5HV4");
        Assert.assertEquals((Object)",", (Object)string);
    }

    @Test
    public void testFilterSystemArgsThrowsIllegalArgumentException() {
        String[] stringArray = new String[4];
        stringArray[0] = "-D";
        try {
            StringUtil.filterSystemArgs(stringArray);
            Assert.fail((String)"Expecting exception: IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFilterSystemArgs() {
        String[] stringArray = new String[]{"J"};
        String[] stringArrayTwo = StringUtil.filterSystemArgs(stringArray);
        Assert.assertFalse((boolean)stringArrayTwo.equals(stringArray));
        Assert.assertEquals((long)1L, (long)stringArrayTwo.length);
        Assert.assertEquals((Object)"J", (Object)stringArrayTwo[0]);
    }
}

