/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.common.util.SSHClient;
import org.apache.kylin.common.util.SSHClientOutput;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSHClientTest
extends LocalFileMetadataTestCase {
    private boolean isRemote;
    private String hostname;
    private int port;
    private String username;
    private String password;

    private void loadPropertiesFile() throws IOException {
        KylinConfig cfg = KylinConfig.getInstanceFromEnv();
        this.isRemote = cfg.getRunAsRemoteCommand();
        this.port = cfg.getRemoteHadoopCliPort();
        this.hostname = cfg.getRemoteHadoopCliHostname();
        this.username = cfg.getRemoteHadoopCliUsername();
        this.password = cfg.getRemoteHadoopCliPassword();
    }

    @Before
    public void before() throws Exception {
        this.createTestMetadata(new String[0]);
        this.loadPropertiesFile();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testCmd() throws Exception {
        if (!this.isRemote) {
            return;
        }
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        SSHClientOutput output = ssh.execCommand("echo hello");
        Assert.assertEquals((long)0L, (long)output.getExitCode());
        Assert.assertEquals((Object)"hello\n", (Object)output.getText());
    }

    @Test
    public void testScp() throws Exception {
        if (!this.isRemote) {
            return;
        }
        SSHClient ssh = new SSHClient(this.hostname, this.port, this.username, this.password);
        File tmpFile = File.createTempFile("test_scp", "", new File("/tmp"));
        tmpFile.deleteOnExit();
        FileUtils.write(tmpFile, (CharSequence)"test_scp", Charset.defaultCharset());
        ssh.scpFileToRemote(tmpFile.getAbsolutePath(), "/tmp");
    }
}

