/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kylin.common.util.RangeUtil;
import org.apache.kylin.shaded.com.google.common.collect.Range;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class RangeUtilTest {
    @Test
    public void testFilter() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        map.put(3, 3);
        map.put(1, 1);
        map.put(2, 2);
        NavigableMap subMap = RangeUtil.filter(map, Range.all());
        Assert.assertEquals((long)subMap.size(), (long)3L);
        subMap = RangeUtil.filter(map, Range.atLeast(2));
        Assert.assertEquals((long)subMap.size(), (long)2L);
        subMap = RangeUtil.filter(map, Range.greaterThan(2));
        Assert.assertEquals((long)subMap.size(), (long)1L);
        subMap = RangeUtil.filter(map, Range.greaterThan(0));
        Assert.assertEquals((long)subMap.size(), (long)3L);
        subMap = RangeUtil.filter(map, Range.greaterThan(5));
        Assert.assertEquals((long)subMap.size(), (long)0L);
        subMap = RangeUtil.filter(map, Range.atMost(2));
        Assert.assertEquals((long)subMap.size(), (long)2L);
        subMap = RangeUtil.filter(map, Range.lessThan(2));
        Assert.assertEquals((long)subMap.size(), (long)1L);
        subMap = RangeUtil.filter(map, Range.lessThan(5));
        Assert.assertEquals((long)subMap.size(), (long)3L);
        subMap = RangeUtil.filter(map, Range.lessThan(0));
        Assert.assertEquals((long)subMap.size(), (long)0L);
    }

    @Test
    public void testBuildRanges() {
        int[] test1 = new int[]{1, 2, 3, 5, 7, 8, 10, 4};
        TreeSet<Integer> treeSet = Sets.newTreeSet();
        for (int t : test1) {
            treeSet.add(t);
        }
        ArrayList<Range<Integer>> ranges = RangeUtil.buildRanges(new TreeSet<Integer>((SortedSet<Integer>)treeSet));
        Assert.assertEquals((long)3L, (long)ranges.size());
    }
}

