/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.RangeUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Range;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test
    public void extremeCase() {
        Range r1 = Range.all();
        Range r2 = Range.all();
        Range<Integer> a = Range.closedOpen(2, 5);
        Assert.assertTrue((boolean)RangeUtil.remove(r1, r2).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a).equals(Lists.newArrayList(Range.lessThan(2), Range.atLeast(5))));
    }

    @Test
    public void testClosed() {
        Range<Integer> anull = Range.closedOpen(0, 0);
        Range<Integer> r1 = Range.closed(2, 5);
        Range<Integer> a1 = Range.open(1, 2);
        Range<Integer> a2 = Range.open(1, 3);
        Range<Integer> a3 = Range.open(1, 5);
        Range<Integer> a4 = Range.open(1, 6);
        Range<Integer> a5 = Range.open(6, 7);
        Range<Integer> a6 = Range.open(5, 7);
        Range<Integer> a7 = Range.open(4, 7);
        Range<Integer> a8 = Range.open(2, 7);
        Range<Integer> a9 = Range.open(1, 7);
        Range<Integer> b1 = Range.closed(1, 2);
        Range<Integer> b2 = Range.closed(1, 3);
        Range<Integer> b3 = Range.closed(1, 5);
        Range<Integer> b4 = Range.closed(1, 6);
        Range<Integer> b5 = Range.closed(6, 7);
        Range<Integer> b6 = Range.closed(5, 7);
        Range<Integer> b7 = Range.closed(4, 7);
        Range<Integer> b8 = Range.closed(2, 7);
        Range<Integer> b9 = Range.closed(1, 7);
        Range<Integer> c1 = Range.open(2, 3);
        Range<Integer> c2 = Range.open(3, 4);
        Range<Integer> c3 = Range.open(4, 5);
        Range<Integer> d1 = Range.closed(2, 3);
        Range<Integer> d2 = Range.closed(3, 4);
        Range<Integer> d3 = Range.closed(4, 5);
        Assert.assertTrue((boolean)RangeUtil.remove(r1, anull).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a1).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a2).equals(Lists.newArrayList(Range.closed(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a3).equals(Lists.newArrayList(Range.closed(5, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a4).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a5).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a6).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a7).equals(Lists.newArrayList(Range.closed(2, 4))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a8).equals(Lists.newArrayList(Range.closed(2, 2))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a9).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b1).equals(Lists.newArrayList(Range.openClosed(2, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b2).equals(Lists.newArrayList(Range.openClosed(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b3).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b4).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b5).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b6).equals(Lists.newArrayList(Range.closedOpen(2, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b7).equals(Lists.newArrayList(Range.closedOpen(2, 4))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b8).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b9).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c1).equals(Lists.newArrayList(Range.closed(2, 2), Range.closed(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c2).equals(Lists.newArrayList(Range.closed(2, 3), Range.closed(4, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c3).equals(Lists.newArrayList(Range.closed(2, 4), Range.closed(5, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d1).equals(Lists.newArrayList(Range.openClosed(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d2).equals(Lists.newArrayList(Range.closedOpen(2, 3), Range.openClosed(4, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d3).equals(Lists.newArrayList(Range.closedOpen(2, 4))));
    }

    @Test
    public void testOpen() {
        Range<Integer> anull = Range.closedOpen(0, 0);
        Range<Integer> r1 = Range.open(2, 5);
        Range<Integer> a1 = Range.open(1, 2);
        Range<Integer> a2 = Range.open(1, 3);
        Range<Integer> a3 = Range.open(1, 5);
        Range<Integer> a4 = Range.open(1, 6);
        Range<Integer> a5 = Range.open(6, 7);
        Range<Integer> a6 = Range.open(5, 7);
        Range<Integer> a7 = Range.open(4, 7);
        Range<Integer> a8 = Range.open(2, 7);
        Range<Integer> a9 = Range.open(1, 7);
        Range<Integer> b1 = Range.closed(1, 2);
        Range<Integer> b2 = Range.closed(1, 3);
        Range<Integer> b3 = Range.closed(1, 5);
        Range<Integer> b4 = Range.closed(1, 6);
        Range<Integer> b5 = Range.closed(6, 7);
        Range<Integer> b6 = Range.closed(5, 7);
        Range<Integer> b7 = Range.closed(4, 7);
        Range<Integer> b8 = Range.closed(2, 7);
        Range<Integer> b9 = Range.closed(1, 7);
        Range<Integer> c1 = Range.open(2, 3);
        Range<Integer> c2 = Range.open(3, 4);
        Range<Integer> c3 = Range.open(4, 5);
        Range<Integer> d1 = Range.closed(2, 3);
        Range<Integer> d2 = Range.closed(3, 4);
        Range<Integer> d3 = Range.closed(4, 5);
        Assert.assertTrue((boolean)RangeUtil.remove(r1, anull).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a1).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a2).equals(Lists.newArrayList(Range.closedOpen(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a3).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a4).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a5).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a6).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a7).equals(Lists.newArrayList(Range.openClosed(2, 4))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a8).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, a9).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b1).equals(Lists.newArrayList(Range.open(2, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b2).equals(Lists.newArrayList(Range.open(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b3).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b4).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b5).equals(Lists.newArrayList(r1)));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b6).equals(Lists.newArrayList(Range.open(2, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b7).equals(Lists.newArrayList(Range.open(2, 4))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b8).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, b9).equals(Lists.newArrayList()));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c1).equals(Lists.newArrayList(Range.closedOpen(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c2).equals(Lists.newArrayList(Range.openClosed(2, 3), Range.closedOpen(4, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, c3).equals(Lists.newArrayList(Range.openClosed(2, 4))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d1).equals(Lists.newArrayList(Range.open(3, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d2).equals(Lists.newArrayList(Range.open(2, 3), Range.open(4, 5))));
        Assert.assertTrue((boolean)RangeUtil.remove(r1, d3).equals(Lists.newArrayList(Range.open(2, 4))));
    }
}

