/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AbstractKylinTestCase;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;

public class LocalFileMetadataTestCase
extends AbstractKylinTestCase {
    public static final String LOCALMETA_TEST_DATA = "../examples/test_case_data/localmeta";
    public static final String LOCALMETA_TEST_DATA_FOR_PARQUET = "../examples/test_case_data/parquet_test";
    public static final String LOCALMETA_TEMP_DATA = "../examples/test_metadata/";

    @Override
    public void createTestMetadata(String ... overlayMetadataDirs) {
        LocalFileMetadataTestCase.staticCreateTestMetadata(true, new OverlayMetaHook(overlayMetadataDirs));
    }

    public static void staticCreateTestMetadata(String ... overlayMetadataDirs) {
        LocalFileMetadataTestCase.staticCreateTestMetadata(true, new OverlayMetaHook(overlayMetadataDirs));
    }

    public static void staticCreateTestMetadata(boolean useTestMeta, MetadataTestCaseHook hook) {
        try {
            File destDir;
            File srcDir;
            KylinConfig.destroyInstance();
            if (new File(LOCALMETA_TEST_DATA).exists()) {
                srcDir = new File(LOCALMETA_TEST_DATA);
                destDir = new File(LOCALMETA_TEMP_DATA);
            } else {
                srcDir = new File("../../examples/test_case_data/localmeta");
                destDir = new File("../../examples/test_metadata/");
            }
            FileUtils.deleteDirectory(destDir);
            if (useTestMeta) {
                FileUtils.copyDirectory(srcDir, destDir);
            }
            if (System.getProperty("KYLIN_CONF") == null && System.getenv("KYLIN_CONF") == null) {
                System.setProperty("KYLIN_CONF", LOCALMETA_TEMP_DATA);
            }
            if (hook != null) {
                hook.hook();
            }
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl(LOCALMETA_TEMP_DATA);
            config.setProperty("kylin.env.hdfs-working-dir", "file:///tmp/kylin");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void cleanAfterClass() {
        block2: {
            File directory = new File(LOCALMETA_TEMP_DATA).exists() ? new File(LOCALMETA_TEMP_DATA) : new File("../../examples/test_metadata/");
            try {
                FileUtils.deleteDirectory(directory);
            }
            catch (IOException e) {
                if (!directory.exists() || directory.list().length <= 0) break block2;
                throw new IllegalStateException("Can't delete directory " + directory, e);
            }
        }
        LocalFileMetadataTestCase.staticCleanupTestMetadata();
    }

    @Override
    public void cleanupTestMetadata() {
        LocalFileMetadataTestCase.cleanAfterClass();
    }

    protected String getLocalWorkingDirectory() {
        String dir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        if (dir.startsWith("file://")) {
            dir = dir.substring("file://".length());
        }
        try {
            return new File(dir).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ResourceStore getStore() {
        return ResourceStore.getStore(KylinConfig.getInstanceFromEnv());
    }

    public static class ExcludeMetaHook
    implements MetadataTestCaseHook {
        private String[] excludeMetadataDirs;

        public ExcludeMetaHook(String ... excludeMetadataDirs) {
            this.excludeMetadataDirs = excludeMetadataDirs;
        }

        @Override
        public void hook() throws IOException {
            for (String exclude : this.excludeMetadataDirs) {
                FileUtils.deleteQuietly(new File(exclude));
            }
        }
    }

    public static class OverlayMetaHook
    implements MetadataTestCaseHook {
        private String[] overlayMetadataDirs;

        public OverlayMetaHook(String ... overlayMetadataDirs) {
            this.overlayMetadataDirs = overlayMetadataDirs;
        }

        @Override
        public void hook() throws IOException {
            for (String overlay : this.overlayMetadataDirs) {
                FileUtils.copyDirectory(new File(overlay), new File(LocalFileMetadataTestCase.LOCALMETA_TEMP_DATA));
            }
        }
    }

    public static interface MetadataTestCaseHook {
        public void hook() throws IOException;
    }
}

