/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.HashMap;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import sun.security.action.GetPropertyAction;

public class HiveCmdBuilderTest {
    @Before
    public void setup() {
        System.setProperty("log4j.configuration", "file:../build/conf/kylin-tools-log4j.properties");
        System.setProperty("KYLIN_CONF", "../examples/test_case_data/localmeta");
    }

    @After
    public void after() throws Exception {
        System.clearProperty("kylin.source.hive.client");
        System.clearProperty("kylin.source.hive.beeline-shell");
        System.clearProperty("kylin.source.hive.beeline-params");
        System.clearProperty("kylin.source.hive.enable-sparksql-for-table-ops");
        System.clearProperty("kylin.source.hive.sparksql-beeline-shell");
        System.clearProperty("kylin.source.hive.sparksql-beeline-params");
    }

    @Test
    public void testHiveCLI() {
        System.setProperty("kylin.source.hive.client", "cli");
        HashMap<String, String> hiveProps = new HashMap<String, String>();
        hiveProps.put("hive.execution.engine", "mr");
        HashMap<String, String> hivePropsOverwrite = new HashMap<String, String>();
        hivePropsOverwrite.put("hive.execution.engine", "tez");
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder("test HiveCLI");
        hiveCmdBuilder.addStatement("USE default;");
        hiveCmdBuilder.addStatement("DROP TABLE `test`;");
        hiveCmdBuilder.addStatement("SHOW\n TABLES;");
        hiveCmdBuilder.setHiveConfProps(hiveProps);
        hiveCmdBuilder.overwriteHiveProps(hivePropsOverwrite);
        Assert.assertEquals((Object)"hive -e \"set mapred.job.name='test HiveCLI';\nUSE default;\nDROP TABLE \\`test\\`;\nSHOW\n TABLES;\n\" --hiveconf hive.execution.engine=tez", (Object)hiveCmdBuilder.build());
    }

    @Test
    public void testBeeline() throws IOException {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        System.setProperty("kylin.source.hive.client", "beeline");
        System.setProperty("kylin.source.hive.beeline-shell", "/spark-client/bin/beeline");
        System.setProperty("kylin.source.hive.beeline-params", "-u jdbc_url");
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement("USE default;");
        hiveCmdBuilder.addStatement("DROP TABLE `test`;");
        hiveCmdBuilder.addStatement("SHOW TABLES;");
        String cmd = hiveCmdBuilder.build();
        String hqlFile = cmd.substring(cmd.lastIndexOf("-f ") + 3).trim();
        hqlFile = hqlFile.substring(0, hqlFile.length() - ";exit $ret_code".length());
        String createFileCmd = cmd.substring(0, cmd.indexOf("EOL\n", cmd.indexOf("EOL\n") + 1) + 3);
        CliCommandExecutor cliCommandExecutor = new CliCommandExecutor();
        Pair<Integer, String> execute2 = cliCommandExecutor.execute(createFileCmd);
        String hqlStatement = FileUtils.readFileToString(new File(hqlFile), Charset.defaultCharset());
        Assert.assertEquals((Object)("USE default;" + lineSeparator + "DROP TABLE `test`;" + lineSeparator + "SHOW TABLES;" + lineSeparator), (Object)hqlStatement);
        this.assertBeelineCmd(cmd);
        FileUtils.forceDelete(new File(hqlFile));
    }

    @Test
    public void testSparkSqlForTableOps() throws IOException {
        System.setProperty("kylin.source.hive.enable-sparksql-for-table-ops", "true");
        System.setProperty("kylin.source.hive.sparksql-beeline-shell", "/spark-client/bin/beeline");
        System.setProperty("kylin.source.hive.sparksql-beeline-params", "-u jdbc_url");
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement("USE default;");
        hiveCmdBuilder.addStatement("DROP TABLE `test`;");
        hiveCmdBuilder.addStatement("SHOW TABLES;");
        String cmd = hiveCmdBuilder.build();
        this.assertBeelineCmd(cmd);
    }

    private void assertBeelineCmd(String cmd) {
        String beelineCmd = cmd.substring(cmd.indexOf("EOL\n", cmd.indexOf("EOL\n") + 1) + 4);
        Assert.assertTrue((boolean)beelineCmd.startsWith("/spark-client/bin/beeline -u jdbc_url"));
    }
}

