/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.junit.Assert;
import org.junit.Test;

public class BytesUtilTest {
    @Test
    public void test() {
        ByteBuffer buffer = ByteBuffer.allocate(10000);
        int[] x = new int[]{1, 2, 3};
        BytesUtil.writeIntArray(x, buffer);
        buffer.flip();
        byte[] buf = new byte[buffer.limit()];
        System.arraycopy(buffer.array(), 0, buf, 0, buffer.limit());
        ByteBuffer newBuffer = ByteBuffer.wrap(buf);
        int[] y = BytesUtil.readIntArray(newBuffer);
        Assert.assertEquals((long)y[2], (long)3L);
    }

    @Test
    public void testBooleanArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10000);
        boolean[] x = new boolean[]{true, false, true};
        BytesUtil.writeBooleanArray(x, buffer);
        buffer.flip();
        boolean[] y = BytesUtil.readBooleanArray(buffer);
        Assert.assertEquals((Object)y[2], (Object)true);
        Assert.assertEquals((Object)y[1], (Object)false);
    }

    @Test
    public void testWriteReadUnsignedInt() {
        this.testWriteReadUnsignedInt(735033, 3);
        this.testWriteReadUnsignedInt(73503300, 4);
    }

    public void testWriteReadUnsignedInt(int testInt, int length) {
        ByteArray ba = new ByteArray(new byte[length]);
        BytesUtil.writeUnsigned(testInt, length, ba.asBuffer());
        byte[] newBytes = new byte[length];
        System.arraycopy(ba.array(), 0, newBytes, 0, length);
        int value = BytesUtil.readUnsigned(new ByteArray(newBytes).asBuffer(), length);
        Assert.assertEquals((long)value, (long)testInt);
        byte[] anOtherNewBytes = new byte[length];
        BytesUtil.writeUnsigned(testInt, anOtherNewBytes, 0, length);
        Assert.assertTrue((boolean)Arrays.equals(anOtherNewBytes, ba.array()));
    }

    @Test
    public void testReadable() {
        String x = "\\x00\\x00\\x00\\x00\\x00\\x01\\xFC\\xA8";
        byte[] bytes = BytesUtil.fromReadableText(x);
        String y = BytesUtil.toHex(bytes);
        Assert.assertEquals((Object)x, (Object)y);
    }
}

