/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourceToolTest
extends LocalFileMetadataTestCase {
    private static final String dstPath = "../examples/test_metadata2/";
    private static final File DIR_1 = new File("../examples/test_case_data/localmeta/execute");
    private static final File DIR_2 = new File("../examples/test_case_data/localmeta/execute_output");
    private static final String FILE_1 = "/execute/1.json";
    private static final String FILE_2 = "/execute_output/2.json";
    private static final List<String> EXEC_FILES = Lists.newArrayList("/execute/1.json", "/execute_output/2.json");

    @Before
    public void setup() throws Exception {
        FileUtils.forceMkdir(DIR_1);
        FileUtils.forceMkdir(DIR_2);
        FileUtils.write(new File("../examples/test_case_data/localmeta/execute/1.json"), "");
        FileUtils.write(new File("../examples/test_case_data/localmeta/execute_output/2.json"), "");
        FileUtils.forceMkdir(new File(dstPath));
        FileUtils.cleanDirectory(new File(dstPath));
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        block2: {
            FileUtils.deleteQuietly(new File("../examples/test_case_data/localmeta/execute/1.json"));
            FileUtils.deleteQuietly(new File("../examples/test_case_data/localmeta/execute_output/2.json"));
            File directory = new File(dstPath);
            try {
                FileUtils.deleteDirectory(directory);
            }
            catch (IOException e) {
                if (!directory.exists() || directory.list().length <= 0) break block2;
                throw new IllegalStateException("Can't delete directory " + directory, e);
            }
        }
        this.cleanupTestMetadata();
    }

    @Test
    public void testCopy() throws IOException {
        KylinConfig dstConfig = KylinConfig.createInstanceFromUri(dstPath);
        ResourceStore srcStore = ResourceStore.getStore(KylinConfig.getInstanceFromEnv());
        ResourceStore dstStore = ResourceStore.getStore(dstConfig);
        Assert.assertNotEquals(srcStore.listResources("/"), dstStore.listResources("/"));
        new ResourceTool().copy(KylinConfig.getInstanceFromEnv(), dstConfig, "/");
        NavigableSet<String> dstFiles = dstStore.listResourcesRecursively("/");
        NavigableSet<String> srcFiles = srcStore.listResourcesRecursively("/");
        Assert.assertTrue((boolean)srcFiles.containsAll(EXEC_FILES));
        Assert.assertFalse((boolean)dstFiles.containsAll(EXEC_FILES));
        srcFiles.removeAll(EXEC_FILES);
        Assert.assertEquals(srcFiles, dstFiles);
    }
}

