/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ContentReader;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStoreTest {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStoreTest.class);
    private static final String PERFORMANCE_TEST_ROOT_PATH = "/performance";
    private static final int TEST_RESOURCE_COUNT = 100;

    public static void testAStore(String url, KylinConfig kylinConfig) throws Exception {
        String oldUrl = ResourceStoreTest.replaceMetadataUrl(kylinConfig, url);
        ResourceStoreTest.testAStore(ResourceStore.getStore(kylinConfig));
        ResourceStoreTest.replaceMetadataUrl(kylinConfig, oldUrl);
    }

    public static void testPerformance(String url, KylinConfig kylinConfig) throws Exception {
        String oldUrl = ResourceStoreTest.replaceMetadataUrl(kylinConfig, url);
        ResourceStoreTest.testPerformance(ResourceStore.getStore(kylinConfig));
        ResourceStoreTest.replaceMetadataUrl(kylinConfig, oldUrl);
    }

    public static String mockUrl(String tag, KylinConfig kylinConfig) {
        String str = kylinConfig.getMetadataUrlPrefix() + "@" + tag;
        return str;
    }

    private static void testAStore(ResourceStore store) throws IOException {
        ResourceStoreTest.testBasics(store);
        ResourceStoreTest.testGetAllResources(store);
        ResourceStoreTest.testUpdateResourceTimestamp(store);
    }

    private static void testPerformance(ResourceStore store) throws IOException {
        logger.info("Test basic functions");
        ResourceStoreTest.testAStore(store);
        logger.info("Basic function ok. Start to test performance for class : " + store.getClass());
        logger.info("Write metadata time : " + ResourceStoreTest.testWritePerformance(store));
        logger.info("Read metadata time  " + ResourceStoreTest.testReadPerformance(store));
        logger.info("Performance test end. Class : " + store.getClass());
    }

    private static void testGetAllResources(ResourceStore store) throws IOException {
        String folder = "/testFolder";
        new ResourceTool().resetR(store, "/testFolder");
        store.checkAndPutResource("/testFolder/res1", new StringEntity("data1"), 1000L, StringEntity.serializer);
        store.checkAndPutResource("/testFolder/res2", new StringEntity("data2"), 2000L, StringEntity.serializer);
        store.checkAndPutResource("/testFolder/sub/res3", new StringEntity("data3"), 3000L, StringEntity.serializer);
        store.checkAndPutResource("/testFolder/res4", new StringEntity("data4"), 4000L, StringEntity.serializer);
        List<StringEntity> result = store.getAllResources("/testFolder", StringEntity.serializer);
        Collections.sort(result);
        ResourceStoreTest.assertEntity(result.get(0), "data1", 1000);
        ResourceStoreTest.assertEntity(result.get(1), "data2", 2000);
        ResourceStoreTest.assertEntity(result.get(2), "data4", 4000);
        Assert.assertEquals((long)3L, (long)result.size());
        result = store.getAllResources("/testFolder", false, new ResourceStore.VisitFilter(2000L, 4000L), new ContentReader<StringEntity>(StringEntity.serializer));
        ResourceStoreTest.assertEntity(result.get(0), "data2", 2000);
        Assert.assertEquals((long)1L, (long)result.size());
        new ResourceTool().resetR(store, "/testFolder");
    }

    private static void assertEntity(StringEntity entity, String data, int ts) {
        Assert.assertEquals((Object)data, (Object)entity.str);
        Assert.assertEquals((long)ts, (long)entity.lastModified);
    }

    private static void testBasics(ResourceStore store) throws IOException {
        String dir1 = "/cube";
        String path1 = "/cube/_test.json";
        StringEntity content1 = new StringEntity("anything");
        String dir2 = "/table";
        String path2 = "/table/_test.json";
        StringEntity content2 = new StringEntity("something");
        String dir3 = "/model_desc";
        String path3 = "/model_desc/_test.json";
        StringEntity content3 = new StringEntity("test check timestamp before delete");
        store.deleteResource(path1);
        store.deleteResource(path2);
        store.deleteResource(path3);
        Assert.assertNull((Object)store.getResource(path1));
        Assert.assertNull((Object)store.getResource(path1, StringEntity.serializer));
        Assert.assertNull((Object)store.getResource(path2));
        Assert.assertNull((Object)store.getResource(path2, StringEntity.serializer));
        Assert.assertNull((Object)store.getResource(path3));
        Assert.assertNull((Object)store.getResource(path3, StringEntity.serializer));
        store.checkAndPutResource(path1, content1, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path1));
        StringEntity t = store.getResource(path1, StringEntity.serializer);
        Assert.assertEquals((Object)content1, (Object)t);
        store.checkAndPutResource(path2, content2, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path2));
        t = store.getResource(path2, StringEntity.serializer);
        Assert.assertEquals((Object)content2, (Object)t);
        t.str = "new string";
        store.checkAndPutResource(path2, t, StringEntity.serializer);
        try {
            t.setLastModified(t.getLastModified() - 1L);
            store.checkAndPutResource(path2, t, StringEntity.serializer);
            Assert.fail((String)"write conflict should trigger IllegalStateException");
        }
        catch (WriteConflictException writeConflictException) {
            // empty catch block
        }
        store.checkAndPutResource(path3, content3, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path3));
        t = store.getResource(path3, StringEntity.serializer);
        Assert.assertEquals((Object)content3, (Object)t);
        NavigableSet<String> list = store.listResources(dir1);
        Assert.assertTrue((boolean)list.contains(path1));
        Assert.assertTrue((!list.contains(path2) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path3) ? 1 : 0) != 0);
        list = store.listResources(dir2);
        Assert.assertTrue((boolean)list.contains(path2));
        Assert.assertTrue((!list.contains(path1) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path3) ? 1 : 0) != 0);
        list = store.listResources(dir3);
        Assert.assertTrue((boolean)list.contains(path3));
        Assert.assertTrue((!list.contains(path1) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path2) ? 1 : 0) != 0);
        list = store.listResources("/");
        Assert.assertTrue((boolean)list.contains(dir1));
        Assert.assertTrue((boolean)list.contains(dir2));
        Assert.assertTrue((boolean)list.contains(dir3));
        Assert.assertTrue((!list.contains(path1) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path2) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path3) ? 1 : 0) != 0);
        list = store.listResources(path1);
        Assert.assertNull(list);
        list = store.listResources(path2);
        Assert.assertNull(list);
        list = store.listResources(path3);
        Assert.assertNull(list);
        store.deleteResource(path1);
        Assert.assertTrue((!store.exists(path1) ? 1 : 0) != 0);
        list = store.listResources(dir1);
        Assert.assertTrue((list == null || !list.contains(path1) ? 1 : 0) != 0);
        store.deleteResource(path2);
        Assert.assertTrue((!store.exists(path2) ? 1 : 0) != 0);
        list = store.listResources(dir2);
        Assert.assertTrue((list == null || !list.contains(path2) ? 1 : 0) != 0);
        long origLastModified = store.getResourceTimestamp(path3);
        long beforeLastModified = origLastModified - 1000L;
        try {
            store.deleteResource(path3, beforeLastModified);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
        }
        Assert.assertTrue((boolean)store.exists(path3));
        list = store.listResources(dir3);
        Assert.assertTrue((list != null && list.contains(path3) ? 1 : 0) != 0);
        store.deleteResource(path3, origLastModified);
        Assert.assertTrue((!store.exists(path3) ? 1 : 0) != 0);
        list = store.listResources(dir3);
        Assert.assertTrue((list == null || !list.contains(path3) ? 1 : 0) != 0);
        content3 = new StringEntity("test check timestamp before delete new");
        store.checkAndPutResource(path3, content3, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path3));
        t = store.getResource(path3, StringEntity.serializer);
        Assert.assertEquals((Object)content3, (Object)t);
        origLastModified = store.getResourceTimestamp(path3);
        long afterLastModified = origLastModified + 1000L;
        store.deleteResource(path3, afterLastModified);
        Assert.assertTrue((!store.exists(path3) ? 1 : 0) != 0);
        list = store.listResources(dir3);
        Assert.assertTrue((list == null || !list.contains(path3) ? 1 : 0) != 0);
    }

    private static long testWritePerformance(ResourceStore store) throws IOException {
        store.deleteResource(PERFORMANCE_TEST_ROOT_PATH);
        StringEntity content = new StringEntity("something");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            String resourcePath = "/performance/res_" + i;
            store.putResource(resourcePath, content, 0L, StringEntity.serializer);
        }
        return System.currentTimeMillis() - startTime;
    }

    private static long testReadPerformance(ResourceStore store) throws IOException {
        long startTime = System.currentTimeMillis();
        int step = 0;
        for (int i = 0; i < 100; ++i) {
            String resourcePath = "/performance/res_" + i;
            StringEntity t = store.getResource(resourcePath, StringEntity.serializer);
            step |= t.toString().length();
        }
        logger.info("step : " + step);
        return System.currentTimeMillis() - startTime;
    }

    public static String replaceMetadataUrl(KylinConfig kylinConfig, String newUrl) {
        String oldUrl = kylinConfig.getMetadataUrl().toString();
        kylinConfig.setProperty("kylin.metadata.url", newUrl);
        return oldUrl;
    }

    private static void testUpdateResourceTimestamp(ResourceStore store) throws IOException {
        String dir1 = "/cube";
        String path1 = "/cube/_test.json";
        StringEntity content1 = new StringEntity("test update timestamp");
        store.deleteResource(path1);
        Assert.assertNull((Object)store.getResource(path1));
        Assert.assertNull((Object)store.getResource(path1, StringEntity.serializer));
        store.checkAndPutResource(path1, content1, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path1));
        StringEntity t = store.getResource(path1, StringEntity.serializer);
        Assert.assertEquals((Object)content1, (Object)t);
        long oldTS = store.getResourceTimestamp(path1);
        long newTS = oldTS + 1000L;
        store.updateTimestamp(path1, newTS);
        long updatedTS = store.getResourceTimestamp(path1);
        Assert.assertEquals((long)updatedTS, (long)newTS);
        newTS = 0L;
        store.updateTimestamp(path1, newTS);
        updatedTS = store.getResourceTimestamp(path1);
        Assert.assertEquals((long)updatedTS, (long)newTS);
        store.deleteResource(path1);
        Assert.assertTrue((!store.exists(path1) ? 1 : 0) != 0);
        NavigableSet<String> list = store.listResources(dir1);
        Assert.assertTrue((list == null || !list.contains(path1) ? 1 : 0) != 0);
    }
}

