/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.ByteArrayInputStream;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceStoreTest;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileResourceStoreTest
extends LocalFileMetadataTestCase {
    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testFileStore() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStoreTest.testAStore(config.getMetadataUrl().toString(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollback() throws Exception {
        ResourceStore store = ResourceStore.getStore(KylinConfig.getInstanceFromEnv());
        byte[] bytes = new byte[]{0, 1, 2};
        try (ResourceStore.Checkpoint cp = store.checkpoint();){
            store.putResource("/res1", new StringEntity("data1"), 1000L, StringEntity.serializer);
        }
        StringEntity str = store.getResource("/res1", StringEntity.serializer);
        Assert.assertEquals((Object)"data1", (Object)str.toString());
        cp = store.checkpoint();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            store.putResource("/res2", is, 2000L);
            is.close();
            store.putResource("/res1", str, 2000L, StringEntity.serializer);
            store.deleteResource("/res1");
            Assert.assertEquals(null, (Object)store.getResource("/res1"));
            RawResource raw = store.getResource("/res2");
            Assert.assertEquals((long)2000L, (long)raw.lastModified());
            raw.content().close();
            cp.rollback();
            Assert.assertEquals(null, (Object)store.getResource("/res2"));
            raw = store.getResource("/res1");
            Assert.assertEquals((long)1000L, (long)raw.lastModified());
            raw.content().close();
        }
        finally {
            cp.close();
        }
    }
}

