/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.File;
import java.lang.reflect.Field;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.HDFSResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HDFSResourceStoreTest
extends LocalFileMetadataTestCase {
    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testListResourcesImpl() throws Exception {
        String path = "../examples/test_metadata/";
        String cp = new File(path).getCanonicalFile().getPath();
        FileSystem fs = HadoopUtil.getFileSystem(cp);
        HDFSResourceStore store = new HDFSResourceStore(KylinConfig.getInstanceFromEnv(), StorageURL.valueOf("hdfs@hdfs"));
        Field field = store.getClass().getDeclaredField("fs");
        field.setAccessible(true);
        field.set(store, fs);
        File f1 = new File(cp + "/resource/resource/e1.json");
        File f2 = new File(cp + "/resource/resource/e2.json");
        if (!f1.getParentFile().exists() && !f1.getParentFile().mkdirs()) {
            throw new RuntimeException("Can not create dir.");
        }
        if (!f1.createNewFile() || !f2.createNewFile()) {
            throw new RuntimeException("Can not create file.");
        }
        Path p = new Path(cp);
        TreeSet<String> resources = store.getAllFilePath(new Path(p, "resource"), "/resource/");
        TreeSet<String> expected = new TreeSet<String>();
        expected.add("/resource/resource/e1.json");
        expected.add("/resource/resource/e2.json");
        Assert.assertEquals(expected, resources);
    }
}

