/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.metrics2;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.sink.FileSink;
import org.apache.kylin.common.metrics.metrics2.HadoopMetrics2Reporter;

public class StandaloneExample {
    public static void main(String[] args) throws Exception {
        MetricRegistry metrics = new MetricRegistry();
        HadoopMetrics2Reporter metrics2Reporter = HadoopMetrics2Reporter.forRegistry(metrics).build(DefaultMetricsSystem.initialize((String)"StandaloneTest"), "Test", "Test", "Test");
        ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).build();
        MetricsSystem metrics2 = DefaultMetricsSystem.instance();
        FileSink sink = new FileSink();
        metrics2.register("filesink", "filesink", (MetricsSink)sink);
        sink.init(new SubsetConfiguration(null, null){

            public String getString(String key) {
                if (key.equals("filename")) {
                    return null;
                }
                return super.getString(key);
            }
        });
        metrics2Reporter.start(500L, TimeUnit.MILLISECONDS);
        consoleReporter.start(2L, TimeUnit.SECONDS);
        StandaloneExample.generateMetrics(metrics, 5000L, 25, TimeUnit.MILLISECONDS, metrics2Reporter, 10);
    }

    public static void generateMetrics(final MetricRegistry metrics, final long metricsToGenerate, final int period, final TimeUnit periodTimeUnit, HadoopMetrics2Reporter metrics2Reporter, int numThreads) throws Exception {
        final ScheduledExecutorService pool = Executors.newScheduledThreadPool(numThreads);
        final CountDownLatch latch = new CountDownLatch(numThreads);
        int i = 0;
        while (i < numThreads) {
            final int id = i++;
            final int halfPeriod = period / 2;
            Runnable task = new Runnable(){
                private long executions = 0L;
                final Random r = new Random();

                @Override
                public void run() {
                    if (this.executions >= metricsToGenerate) {
                        return;
                    }
                    metrics.counter("foo counter thread" + id).inc();
                    ++this.executions;
                    if (this.executions < metricsToGenerate) {
                        pool.schedule(this, (long)(period + this.r.nextInt(halfPeriod)), periodTimeUnit);
                    } else {
                        latch.countDown();
                    }
                }
            };
            pool.schedule(task, (long)period, periodTimeUnit);
        }
        while (!latch.await(2L, TimeUnit.SECONDS)) {
            metrics2Reporter.printQueueDebugMessage();
        }
        pool.shutdown();
        pool.awaitTermination(5000L, TimeUnit.SECONDS);
    }
}

