/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.metrics2;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.kylin.common.metrics.metrics2.HadoopMetrics2Reporter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HadoopMetrics2ReporterTest {
    private MetricRegistry mockRegistry;
    private MetricsSystem mockMetricsSystem;
    private String recordName = "myserver";
    private HadoopMetrics2Reporter metrics2Reporter;

    @Before
    public void setup() {
        this.mockRegistry = (MetricRegistry)Mockito.mock(MetricRegistry.class);
        this.mockMetricsSystem = (MetricsSystem)Mockito.mock(MetricsSystem.class);
        this.recordName = "myserver";
        this.metrics2Reporter = HadoopMetrics2Reporter.forRegistry(this.mockRegistry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build(this.mockMetricsSystem, "MyServer", "My Cool Server", this.recordName);
    }

    private void verifyRecordBuilderUnits(MetricsRecordBuilder recordBuilder) {
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).tag(HadoopMetrics2Reporter.RATE_UNIT_LABEL, this.metrics2Reporter.getRateUnit());
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).tag(HadoopMetrics2Reporter.DURATION_UNIT_LABEL, this.metrics2Reporter.getDurationUnit());
    }

    @Test
    public void testBuilderDefaults() {
        HadoopMetrics2Reporter.Builder builder = HadoopMetrics2Reporter.forRegistry(this.mockRegistry);
        String jmxContext = "MyJmxContext;sub=Foo";
        String desc = "Description";
        String recordName = "Metrics";
        HadoopMetrics2Reporter reporter = builder.build(this.mockMetricsSystem, "MyJmxContext;sub=Foo", "Description", "Metrics");
        Assert.assertEquals((Object)this.mockMetricsSystem, (Object)reporter.getMetrics2System());
        Assert.assertEquals(null, (Object)reporter.getContext());
        Assert.assertEquals((Object)"Metrics", (Object)reporter.getRecordName());
    }

    @Test
    public void testGaugeReporting() {
        final AtomicLong gaugeValue = new AtomicLong(0L);
        Gauge<Long> gauge = new Gauge<Long>(){

            public Long getValue() {
                return gaugeValue.get();
            }
        };
        TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
        gauges.put("my_gauge", gauge);
        this.metrics2Reporter.setDropwizardGauges(gauges);
        gaugeValue.set(5L);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_gauge", (String)""), gaugeValue.get());
        this.verifyRecordBuilderUnits(recordBuilder);
        Assert.assertTrue((String)"Should not be the same map instance after collection", (gauges != this.metrics2Reporter.getDropwizardGauges() ? 1 : 0) != 0);
    }

    @Test
    public void testCounterReporting() {
        Counter counter = new Counter();
        TreeMap<String, Counter> counters = new TreeMap<String, Counter>();
        counters.put("my_counter", counter);
        this.metrics2Reporter.setDropwizardCounters(counters);
        counter.inc(5L);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addCounter(Interns.info((String)"my_counter", (String)""), 5L);
        this.verifyRecordBuilderUnits(recordBuilder);
        Assert.assertTrue((String)"Should not be the same map instance after collection", (counters != this.metrics2Reporter.getDropwizardCounters() ? 1 : 0) != 0);
    }

    @Test
    public void testHistogramReporting() {
        String metricName = "my_histogram";
        Histogram histogram = (Histogram)Mockito.mock(Histogram.class);
        Snapshot snapshot = (Snapshot)Mockito.mock(Snapshot.class);
        long count = 10L;
        double percentile75 = 75.0;
        double percentile95 = 95.0;
        double percentile98 = 98.0;
        double percentile99 = 99.0;
        double percentile999 = 999.0;
        double median = 50.0;
        double mean = 60.0;
        long min = 1L;
        long max = 100L;
        double stddev = 10.0;
        Mockito.when((Object)snapshot.get75thPercentile()).thenReturn((Object)percentile75);
        Mockito.when((Object)snapshot.get95thPercentile()).thenReturn((Object)percentile95);
        Mockito.when((Object)snapshot.get98thPercentile()).thenReturn((Object)percentile98);
        Mockito.when((Object)snapshot.get99thPercentile()).thenReturn((Object)percentile99);
        Mockito.when((Object)snapshot.get999thPercentile()).thenReturn((Object)percentile999);
        Mockito.when((Object)snapshot.getMedian()).thenReturn((Object)median);
        Mockito.when((Object)snapshot.getMean()).thenReturn((Object)mean);
        Mockito.when((Object)snapshot.getMin()).thenReturn((Object)min);
        Mockito.when((Object)snapshot.getMax()).thenReturn((Object)max);
        Mockito.when((Object)snapshot.getStdDev()).thenReturn((Object)stddev);
        Mockito.when((Object)histogram.getCount()).thenReturn((Object)count);
        Mockito.when((Object)histogram.getSnapshot()).thenReturn((Object)snapshot);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        TreeMap<String, Histogram> histograms = new TreeMap<String, Histogram>();
        histograms.put("my_histogram", histogram);
        this.metrics2Reporter.setDropwizardHistograms(histograms);
        this.metrics2Reporter.getMetrics(collector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_max", (String)""), this.metrics2Reporter.convertDuration(max));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_min", (String)""), this.metrics2Reporter.convertDuration(min));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_median", (String)""), this.metrics2Reporter.convertDuration(median));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_count", (String)""), count);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_stddev", (String)""), this.metrics2Reporter.convertDuration(stddev));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_75thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile75));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_95thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile95));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_98thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile98));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_99thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile99));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_histogram_999thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile999));
        this.verifyRecordBuilderUnits(recordBuilder);
        Assert.assertTrue((String)"Should not be the same map instance after collection", (histograms != this.metrics2Reporter.getDropwizardHistograms() ? 1 : 0) != 0);
    }

    @Test
    public void testTimerReporting() {
        String metricName = "my_timer";
        Timer timer = (Timer)Mockito.mock(Timer.class);
        Snapshot snapshot = (Snapshot)Mockito.mock(Snapshot.class);
        TreeMap<String, Timer> timers = new TreeMap<String, Timer>();
        timers.put("my_timer", timer);
        this.metrics2Reporter.setDropwizardTimers(timers);
        long count = 10L;
        double meanRate = 1.0;
        double oneMinRate = 2.0;
        double fiveMinRate = 5.0;
        double fifteenMinRate = 10.0;
        Mockito.when((Object)timer.getCount()).thenReturn((Object)count);
        Mockito.when((Object)timer.getMeanRate()).thenReturn((Object)meanRate);
        Mockito.when((Object)timer.getOneMinuteRate()).thenReturn((Object)oneMinRate);
        Mockito.when((Object)timer.getFiveMinuteRate()).thenReturn((Object)fiveMinRate);
        Mockito.when((Object)timer.getFifteenMinuteRate()).thenReturn((Object)fifteenMinRate);
        Mockito.when((Object)timer.getSnapshot()).thenReturn((Object)snapshot);
        double percentile75 = 75.0;
        double percentile95 = 95.0;
        double percentile98 = 98.0;
        double percentile99 = 99.0;
        double percentile999 = 999.0;
        double median = 50.0;
        double mean = 60.0;
        long min = 1L;
        long max = 100L;
        double stddev = 10.0;
        Mockito.when((Object)snapshot.get75thPercentile()).thenReturn((Object)percentile75);
        Mockito.when((Object)snapshot.get95thPercentile()).thenReturn((Object)percentile95);
        Mockito.when((Object)snapshot.get98thPercentile()).thenReturn((Object)percentile98);
        Mockito.when((Object)snapshot.get99thPercentile()).thenReturn((Object)percentile99);
        Mockito.when((Object)snapshot.get999thPercentile()).thenReturn((Object)percentile999);
        Mockito.when((Object)snapshot.getMedian()).thenReturn((Object)median);
        Mockito.when((Object)snapshot.getMean()).thenReturn((Object)mean);
        Mockito.when((Object)snapshot.getMin()).thenReturn((Object)min);
        Mockito.when((Object)snapshot.getMax()).thenReturn((Object)max);
        Mockito.when((Object)snapshot.getStdDev()).thenReturn((Object)stddev);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_count", (String)""), count);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_mean_rate", (String)""), this.metrics2Reporter.convertRate(meanRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_1min_rate", (String)""), this.metrics2Reporter.convertRate(oneMinRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_5min_rate", (String)""), this.metrics2Reporter.convertRate(fiveMinRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_15min_rate", (String)""), this.metrics2Reporter.convertRate(fifteenMinRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_max", (String)""), this.metrics2Reporter.convertDuration(max));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_min", (String)""), this.metrics2Reporter.convertDuration(min));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_median", (String)""), this.metrics2Reporter.convertDuration(median));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_stddev", (String)""), this.metrics2Reporter.convertDuration(stddev));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_75thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile75));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_95thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile95));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_98thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile98));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_99thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile99));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_timer_999thpercentile", (String)""), this.metrics2Reporter.convertDuration(percentile999));
        this.verifyRecordBuilderUnits(recordBuilder);
        Assert.assertTrue((String)"Should not be the same map instance after collection", (timers != this.metrics2Reporter.getDropwizardTimers() ? 1 : 0) != 0);
    }

    @Test
    public void testMeterReporting() {
        String metricName = "my_meter";
        Meter meter = (Meter)Mockito.mock(Meter.class);
        TreeMap<String, Meter> meters = new TreeMap<String, Meter>();
        meters.put("my_meter", meter);
        this.metrics2Reporter.setDropwizardMeters(meters);
        long count = 10L;
        double meanRate = 1.0;
        double oneMinRate = 2.0;
        double fiveMinRate = 5.0;
        double fifteenMinRate = 10.0;
        Mockito.when((Object)meter.getCount()).thenReturn((Object)count);
        Mockito.when((Object)meter.getMeanRate()).thenReturn((Object)meanRate);
        Mockito.when((Object)meter.getOneMinuteRate()).thenReturn((Object)oneMinRate);
        Mockito.when((Object)meter.getFiveMinuteRate()).thenReturn((Object)fiveMinRate);
        Mockito.when((Object)meter.getFifteenMinuteRate()).thenReturn((Object)fifteenMinRate);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_meter_count", (String)""), count);
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_meter_mean_rate", (String)""), this.metrics2Reporter.convertRate(meanRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_meter_1min_rate", (String)""), this.metrics2Reporter.convertRate(oneMinRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_meter_5min_rate", (String)""), this.metrics2Reporter.convertRate(fiveMinRate));
        ((MetricsRecordBuilder)Mockito.verify((Object)recordBuilder)).addGauge(Interns.info((String)"my_meter_15min_rate", (String)""), this.metrics2Reporter.convertRate(fifteenMinRate));
        this.verifyRecordBuilderUnits(recordBuilder);
        Assert.assertTrue((String)"Should not be the same map instance after collection", (meters != this.metrics2Reporter.getDropwizardMeters() ? 1 : 0) != 0);
    }

    @Test
    public void metrics2CycleIsNonDestructive() {
        this.metrics2Reporter.setDropwizardCounters(Collections.unmodifiableSortedMap(new TreeMap()));
        this.metrics2Reporter.setDropwizardGauges(Collections.unmodifiableSortedMap(new TreeMap()));
        this.metrics2Reporter.setDropwizardHistograms(Collections.unmodifiableSortedMap(new TreeMap()));
        this.metrics2Reporter.setDropwizardMeters(Collections.unmodifiableSortedMap(new TreeMap()));
        this.metrics2Reporter.setDropwizardTimers(Collections.unmodifiableSortedMap(new TreeMap()));
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
    }

    @Test
    public void cachedMetricsAreClearedAfterCycle() {
        TreeMap<String, Counter> counters = new TreeMap<String, Counter>();
        TreeMap<String, Gauge> gauges = new TreeMap<String, Gauge>();
        TreeMap<String, Histogram> histograms = new TreeMap<String, Histogram>();
        TreeMap<String, Meter> meters = new TreeMap<String, Meter>();
        TreeMap<String, Timer> timers = new TreeMap<String, Timer>();
        this.metrics2Reporter.setDropwizardCounters(counters);
        this.metrics2Reporter.setDropwizardGauges(gauges);
        this.metrics2Reporter.setDropwizardHistograms(histograms);
        this.metrics2Reporter.setDropwizardMeters(meters);
        this.metrics2Reporter.setDropwizardTimers(timers);
        MetricsCollector collector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        MetricsRecordBuilder recordBuilder = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)collector.addRecord(this.recordName)).thenReturn((Object)recordBuilder);
        this.metrics2Reporter.getMetrics(collector, true);
        Assert.assertTrue((counters != this.metrics2Reporter.getDropwizardCounters() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.metrics2Reporter.getDropwizardCounters().size());
        Assert.assertTrue((gauges != this.metrics2Reporter.getDropwizardGauges() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.metrics2Reporter.getDropwizardGauges().size());
        Assert.assertTrue((histograms != this.metrics2Reporter.getDropwizardHistograms() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.metrics2Reporter.getDropwizardHistograms().size());
        Assert.assertTrue((meters != this.metrics2Reporter.getDropwizardMeters() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.metrics2Reporter.getDropwizardMeters().size());
        Assert.assertTrue((timers != this.metrics2Reporter.getDropwizardTimers() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.metrics2Reporter.getDropwizardTimers().size());
    }
}

