/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import org.apache.kylin.common.StorageURL;
import org.junit.Assert;
import org.junit.Test;

public class StorageURLTest {
    @Test
    public void testBasic() {
        StorageURL id = new StorageURL("hello@hbase");
        Assert.assertEquals((Object)"hello", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"hbase", (Object)id.getScheme());
        Assert.assertEquals((long)0L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"hello@hbase", (Object)id.toString());
        id = new StorageURL("hello@hbase,a=b,c=d");
        Assert.assertEquals((Object)"hello", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"hbase", (Object)id.getScheme());
        Assert.assertEquals((long)2L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"b", (Object)id.getParameter("a"));
        Assert.assertEquals((Object)"d", (Object)id.getParameter("c"));
        Assert.assertEquals((Object)"hello@hbase,a=b,c=d", (Object)id.toString());
        StorageURL o = new StorageURL("hello@hbase,c=d");
        StorageURL o2 = new StorageURL("hello@hbase,a=b");
        StorageURL id2 = o.copy(o2.getAllParameters());
        Assert.assertEquals((Object)"hello", (Object)id2.getIdentifier());
        Assert.assertEquals((Object)"hbase", (Object)id2.getScheme());
        Assert.assertEquals((long)1L, (long)id2.getAllParameters().size());
        Assert.assertEquals((Object)"b", (Object)id2.getParameter("a"));
        Assert.assertEquals((Object)"hello@hbase,a=b", (Object)id2.toString());
        Assert.assertEquals((Object)"hello@hbase,c=d", (Object)o.toString());
        Assert.assertEquals((Object)"hello@hbase,a=b", (Object)o2.toString());
    }

    @Test(expected=NullPointerException.class)
    public void testNullInput() {
        new StorageURL(null);
    }

    @Test
    public void testHDFS() {
        StorageURL id = new StorageURL("master_ci_instance@hdfs,path=hdfs://sandbox.hortonworks.com:8020/kylin/master_ci_instance/metadata/f112fe00-6f99-4f8e-b075-d57c08501106");
        Assert.assertEquals((Object)"master_ci_instance", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"hdfs", (Object)id.getScheme());
        Assert.assertEquals((long)1L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"master_ci_instance@hdfs,path=hdfs://sandbox.hortonworks.com:8020/kylin/master_ci_instance/metadata/f112fe00-6f99-4f8e-b075-d57c08501106", (Object)id.toString());
    }

    @Test
    public void testEdgeCases() {
        StorageURL id = new StorageURL("");
        Assert.assertEquals((Object)"kylin_metadata", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"", (Object)id.getScheme());
        Assert.assertEquals((long)0L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"kylin_metadata", (Object)id.toString());
        id = new StorageURL("hello@");
        Assert.assertEquals((Object)"hello", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"", (Object)id.getScheme());
        Assert.assertEquals((long)0L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"hello", (Object)id.toString());
        id = new StorageURL("hello@hbase,a");
        Assert.assertEquals((Object)"hello", (Object)id.getIdentifier());
        Assert.assertEquals((Object)"hbase", (Object)id.getScheme());
        Assert.assertEquals((long)1L, (long)id.getAllParameters().size());
        Assert.assertEquals((Object)"", (Object)id.getParameter("a"));
        Assert.assertEquals((Object)"hello@hbase,a", (Object)id.toString());
    }

    @Test
    public void testValueOfCache() {
        StorageURL id1 = StorageURL.valueOf("hello@hbase");
        StorageURL id2 = StorageURL.valueOf("hello@hbase");
        StorageURL id3 = StorageURL.valueOf("hello @ hbase");
        StorageURL id4 = StorageURL.valueOf("hello@hbase,a=b");
        Assert.assertTrue((id1 == id2 ? 1 : 0) != 0);
        Assert.assertTrue((id1 != id3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)id1.equals(id3));
        Assert.assertTrue((id2 != id4 ? 1 : 0) != 0);
        Assert.assertTrue((!id2.equals(id4) ? 1 : 0) != 0);
    }
}

